/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.openapi.model;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNType;
import org.kie.dmn.openapi.NamingPolicy;
import org.kie.dmn.openapi.model.DMNModelIOSets;

public class DMNOASResult {
    private final ObjectNode jsonSchemaNode;
    private final Map<DMNModel, DMNModelIOSets> ioSets = new LinkedHashMap<DMNModel, DMNModelIOSets>();
    private final Map<DMNType, Schema> schemas;
    private final NamingPolicy namingPolicy;

    public DMNOASResult(ObjectNode jsonSchemaNode, Collection<DMNModelIOSets> ioSets, Map<DMNType, Schema> schemas, NamingPolicy namingPolicy) {
        this.jsonSchemaNode = jsonSchemaNode.deepCopy();
        for (DMNModelIOSets ioSet : ioSets) {
            this.ioSets.put(ioSet.getModel(), ioSet);
        }
        this.schemas = Collections.unmodifiableMap(schemas);
        this.namingPolicy = namingPolicy;
    }

    public DMNModelIOSets lookupIOSetsByModel(DMNModel model) {
        return this.ioSets.get(model);
    }

    public ObjectNode getJsonSchemaNode() {
        return this.jsonSchemaNode;
    }

    public Collection<DMNModelIOSets> getIoSets() {
        return this.ioSets.values();
    }

    public Map<DMNType, Schema> getSchemas() {
        return this.schemas;
    }

    public NamingPolicy getNamingPolicy() {
        return this.namingPolicy;
    }
}

