/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.openapi.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.smallrye.openapi.runtime.io.JsonUtil;
import io.smallrye.openapi.runtime.io.schema.SchemaWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNType;
import org.kie.dmn.core.impl.CompositeTypeImpl;
import org.kie.dmn.openapi.DMNOASGenerator;
import org.kie.dmn.openapi.NamingPolicy;
import org.kie.dmn.openapi.impl.DMNTypeSchemas;
import org.kie.dmn.openapi.impl.DefaultNamingPolicy;
import org.kie.dmn.openapi.impl.NamespaceAwareNamingPolicy;
import org.kie.dmn.openapi.model.DMNModelIOSets;
import org.kie.dmn.openapi.model.DMNOASResult;
import org.kie.dmn.typesafe.DMNTypeUtils;

public class DMNOASGeneratorImpl
implements DMNOASGenerator {
    private final List<DMNModel> dmnModels;
    private final List<DMNModelIOSets> ioSets = new ArrayList<DMNModelIOSets>();
    private final Set<DMNType> typesIndex = new HashSet<DMNType>();
    private NamingPolicy namingPolicy;
    private final Map<DMNType, Schema> schemas = new HashMap<DMNType, Schema>();
    private ObjectNode jsonSchema;

    public DMNOASGeneratorImpl(Collection<DMNModel> models) {
        this.dmnModels = new ArrayList<DMNModel>(models);
    }

    @Override
    public DMNOASResult build() {
        this.indexModels();
        this.assignNamesToIOSets();
        this.determineNamingPolicy();
        this.schemas.putAll(new DMNTypeSchemas(this.ioSets, this.typesIndex, this.namingPolicy).generateSchemas());
        this.prepareSerializaton();
        return new DMNOASResult(this.jsonSchema, this.ioSets, this.schemas, this.namingPolicy);
    }

    private void indexModels() {
        for (DMNModel model : this.dmnModels) {
            DMNModelIOSets s = new DMNModelIOSets(model);
            this.ioSets.add(s);
            this.visitForIndexing(s);
        }
    }

    private void prepareSerializaton() {
        ObjectNode tree = JsonUtil.objectNode();
        ObjectNode definitions = JsonUtil.objectNode();
        tree.set("definitions", (JsonNode)definitions);
        for (Map.Entry<DMNType, Schema> kv : this.schemas.entrySet()) {
            SchemaWriter.writeSchema((ObjectNode)definitions, (Schema)kv.getValue(), (String)this.namingPolicy.getName(kv.getKey()));
        }
        this.jsonSchema = tree;
    }

    private void determineNamingPolicy() {
        this.namingPolicy = new DefaultNamingPolicy();
        if (this.namingIntegrityCheck()) {
            return;
        }
        this.namingPolicy = new NamespaceAwareNamingPolicy(this.dmnModels);
        if (this.namingIntegrityCheck()) {
            return;
        }
        throw new IllegalStateException("Couldn't determine unique naming policy");
    }

    private boolean namingIntegrityCheck() {
        return (long)this.typesIndex.size() == this.typesIndex.stream().map(this.namingPolicy::getName).distinct().count();
    }

    private void assignNamesToIOSets() {
        for (int i = 0; i < this.ioSets.size(); ++i) {
            DMNModelIOSets si = this.ioSets.get(i);
            si.setInputSetName(this.findUniqueNameUsing("InputSet", i + 1));
            si.setOutputSetName(this.findUniqueNameUsing("OutputSet", i + 1));
            int j = 1;
            for (DMNModelIOSets.DSIOSets ds : si.getDSIOSets()) {
                ds.setDSInputSetName(this.findUniqueNameUsing("InputSetDS" + j, i + 1));
                ds.setDSOutputSetName(this.findUniqueNameUsing("OutputSetDS" + j, i + 1));
                ++j;
            }
        }
    }

    private String findUniqueNameUsing(String radix, int suffixH) {
        String candidate;
        String string = candidate = this.dmnModels.size() > 1 ? radix + suffixH : radix;
        while (this.indexContainsName(candidate)) {
            candidate = "_" + candidate;
        }
        return candidate;
    }

    private boolean indexContainsName(String candidate) {
        return this.typesIndex.stream().map(DMNType::getName).anyMatch(candidate::equals);
    }

    private void visitForIndexing(DMNModelIOSets s) {
        this.visitForIndexing(s.getOutputSet());
        this.visitForIndexing(s.getInputSet());
        for (DMNModelIOSets.DSIOSets ds : s.getDSIOSets()) {
            this.visitForIndexing(ds.getDSOutputSet());
            this.visitForIndexing(ds.getDSInputSet());
        }
    }

    private void visitForIndexing(DMNType idnType) {
        if (this.typesIndex.contains(idnType)) {
            return;
        }
        if (DMNTypeUtils.isFEELBuiltInType((DMNType)idnType)) {
            return;
        }
        this.typesIndex.add(idnType);
        if (idnType.getBaseType() != null) {
            this.visitForIndexing(idnType.getBaseType());
        }
        if (idnType instanceof CompositeTypeImpl) {
            CompositeTypeImpl compType = (CompositeTypeImpl)idnType;
            for (DMNType v : compType.getFields().values()) {
                this.visitForIndexing(v);
            }
        }
    }
}

