/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.lang.ast;

import java.math.BigDecimal;
import org.antlr.v4.runtime.ParserRuleContext;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.feel.lang.EvaluationContext;
import org.kie.dmn.feel.lang.Type;
import org.kie.dmn.feel.lang.ast.BaseNode;
import org.kie.dmn.feel.util.EvalHelper;
import org.kie.dmn.feel.util.Msg;

public class SignedUnaryNode
extends BaseNode {
    private Sign sign;
    private BaseNode expression;

    public SignedUnaryNode(ParserRuleContext ctx, BaseNode expr) {
        super(ctx);
        this.sign = Sign.determineSign(ctx.start.getText());
        this.expression = expr;
    }

    public Sign getSign() {
        return this.sign;
    }

    public BaseNode getExpression() {
        return this.expression;
    }

    @Override
    public Object evaluate(EvaluationContext ctx) {
        if (this.expression == null) {
            return null;
        }
        BigDecimal result = EvalHelper.getBigDecimalOrNull(this.expression.evaluate(ctx));
        if (result == null) {
            ctx.notifyEvt(this.astEvent(FEELEvent.Severity.WARN, Msg.createMessage(Msg.NEGATING_A_NULL)));
            return null;
        }
        if (Sign.NEGATIVE == this.sign) {
            return BigDecimal.valueOf(-1L).multiply(result);
        }
        return result;
    }

    @Override
    public Type getResultType() {
        return this.expression.getResultType();
    }

    public static enum Sign {
        POSITIVE,
        NEGATIVE;


        public static Sign determineSign(String str) {
            if ("-".equals(str)) {
                return NEGATIVE;
            }
            if ("+".equals(str)) {
                return POSITIVE;
            }
            throw new IllegalArgumentException("Unknown sign: '" + str + "'. Expecting either '+' or '-'.");
        }
    }
}

