/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions;

import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.feel.runtime.events.InvalidParametersEvent;
import org.kie.dmn.feel.runtime.functions.BaseFEELFunction;
import org.kie.dmn.feel.runtime.functions.FEELFnResult;
import org.kie.dmn.feel.runtime.functions.ParameterName;

public class DateTimeFunction
extends BaseFEELFunction {
    public DateTimeFunction() {
        super("date and time");
    }

    public FEELFnResult<TemporalAccessor> invoke(@ParameterName(value="from") String val) {
        if (val == null) {
            return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "from", "cannot be null"));
        }
        try {
            if (val.contains("T")) {
                return FEELFnResult.ofResult(DateTimeFormatter.ISO_DATE_TIME.parseBest(val, ZonedDateTime::from, OffsetDateTime::from, LocalDateTime::from));
            }
            TemporalAccessor value = DateTimeFormatter.ISO_DATE.parse((CharSequence)val, LocalDate::from);
            return FEELFnResult.ofResult(LocalDateTime.of((LocalDate)value, LocalTime.of(0, 0)));
        }
        catch (Exception e) {
            return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "from", "date-parsing exception", e));
        }
    }

    public FEELFnResult<TemporalAccessor> invoke(@ParameterName(value="date") Temporal date, @ParameterName(value="time") Temporal time) {
        if (date == null) {
            return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "date", "cannot be null"));
        }
        if (!(date instanceof LocalDate)) {
            return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "date", "must be an instance of LocalDate"));
        }
        if (time == null) {
            return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "time", "cannot be null"));
        }
        if (!(time instanceof LocalTime) && !(time instanceof OffsetTime)) {
            return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "time", "must be an instance of LocalTime or OffsetTime"));
        }
        try {
            if (time instanceof LocalTime) {
                return FEELFnResult.ofResult(LocalDateTime.of((LocalDate)date, (LocalTime)time));
            }
            return FEELFnResult.ofResult(ZonedDateTime.of((LocalDate)date, LocalTime.from(time), ZoneOffset.from(time)));
        }
        catch (DateTimeException e) {
            return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "input parameters date-parsing exception", e));
        }
    }
}

