/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.lang.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.function.Supplier;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.api.feel.runtime.events.FEELEventListener;
import org.kie.dmn.feel.lang.EvaluationContext;
import org.kie.dmn.feel.lang.impl.ExecutionFrame;
import org.kie.dmn.feel.lang.impl.ExecutionFrameImpl;
import org.kie.dmn.feel.lang.impl.FEELEventListenersManager;
import org.kie.dmn.feel.lang.impl.RootExecutionFrame;
import org.kie.dmn.feel.util.EvalHelper;

public class EvaluationContextImpl
implements EvaluationContext {
    private final FEELEventListenersManager eventsManager;
    private Stack<ExecutionFrame> stack;
    private DMNRuntime dmnRuntime;

    public EvaluationContextImpl(FEELEventListenersManager eventsManager) {
        this.eventsManager = eventsManager;
        this.stack = new Stack();
        this.push(RootExecutionFrame.INSTANCE);
        ExecutionFrameImpl global = new ExecutionFrameImpl(RootExecutionFrame.INSTANCE);
        this.push(global);
    }

    public EvaluationContextImpl(FEELEventListenersManager eventsManager, DMNRuntime dmnRuntime) {
        this(eventsManager);
        this.dmnRuntime = dmnRuntime;
    }

    public void push(ExecutionFrame obj) {
        this.stack.push(obj);
    }

    public ExecutionFrame pop() {
        return this.stack.pop();
    }

    public ExecutionFrame peek() {
        return this.stack.peek();
    }

    public Stack<ExecutionFrame> getStack() {
        return this.stack;
    }

    @Override
    public void enterFrame() {
        this.push(new ExecutionFrameImpl(this.peek()));
    }

    @Override
    public void exitFrame() {
        this.pop();
    }

    @Override
    public void setValue(String name, Object value) {
        this.peek().setValue(name, EvalHelper.coerceNumber(value));
    }

    public void setValues(Map<String, Object> values) {
        values.forEach(this::setValue);
    }

    @Override
    public Object getValue(String name) {
        return this.peek().getValue(name);
    }

    @Override
    public Object getValue(String[] name) {
        if (name.length == 1) {
            return this.getValue(name[0]);
        }
        if (name.length > 1) {
            Map actualObject = (Map)this.peek().getValue(name[0]);
            for (int i = 1; i < name.length - 1; ++i) {
                if ((actualObject = (Map)actualObject.get(name[i])) != null) continue;
                return null;
            }
            return actualObject.get(name[name.length - 1]);
        }
        return null;
    }

    @Override
    public boolean isDefined(String name) {
        return this.peek().isDefined(name);
    }

    @Override
    public boolean isDefined(String[] name) {
        if (name.length == 1) {
            return this.isDefined(name[0]);
        }
        if (name.length > 1) {
            Map actualObject = (Map)this.peek().getValue(name[0]);
            for (int i = 1; i < name.length - 1; ++i) {
                if ((actualObject = (Map)actualObject.get(name[i])) != null) continue;
                return false;
            }
            return actualObject.get(name[name.length - 1]) != null;
        }
        return false;
    }

    @Override
    public Map<String, Object> getAllValues() {
        HashMap<String, Object> values = new HashMap<String, Object>();
        for (int i = 0; i < this.stack.size(); ++i) {
            values.putAll(((ExecutionFrame)this.stack.get(i)).getAllValues());
        }
        return values;
    }

    @Override
    public void notifyEvt(Supplier<FEELEvent> event) {
        FEELEventListenersManager.notifyListeners(this.eventsManager, event);
    }

    @Override
    public Collection<FEELEventListener> getListeners() {
        return this.eventsManager.getListeners();
    }

    @Override
    public DMNRuntime getDMNRuntime() {
        return this.dmnRuntime;
    }
}

