/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.events;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.feel.runtime.events.FEELEventBase;

public class InvalidParametersEvent
extends FEELEventBase
implements FEELEvent {
    private String genericProblem;
    private String paramNameInError;
    private String paramProblem;
    private String nodeName;
    private final Map<String, Object> actualParameters = new HashMap<String, Object>();

    public InvalidParametersEvent(FEELEvent.Severity severity, String genericProblem) {
        super(severity, null, null);
        this.genericProblem = genericProblem;
    }

    public InvalidParametersEvent(FEELEvent.Severity severity, String genericProblem, Throwable sourceException) {
        super(severity, null, sourceException);
        this.genericProblem = genericProblem;
    }

    public InvalidParametersEvent(FEELEvent.Severity severity, String paramNameInError, String paramProblem) {
        super(severity, null, null);
        this.paramNameInError = paramNameInError;
        this.paramProblem = paramProblem;
    }

    public InvalidParametersEvent(FEELEvent.Severity severity, String paramNameInError, String paramProblem, Throwable sourceException) {
        super(severity, null, sourceException);
        this.paramNameInError = paramNameInError;
        this.paramProblem = paramProblem;
    }

    @Override
    public String getMessage() {
        if (this.genericProblem == null) {
            return "The parameter '" + this.paramNameInError + "', in function " + this.getNodeName() + "(), " + this.paramProblem + ".";
        }
        return this.genericProblem;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public void setActualParameters(List<String> parameterNames, List<Object> parameterValues) {
        this.actualParameters.clear();
        IntStream.range(0, parameterNames.size()).forEach(idx -> this.actualParameters.put((String)parameterNames.get(idx), parameterValues.get(idx)));
    }

    public Map<String, Object> getActualParameters() {
        return Collections.unmodifiableMap(this.actualParameters);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("InvalidParametersEvent{").append("getSeverity()=").append(this.getSeverity()).append(", nodeName=").append(this.nodeName).append(", message=").append(this.getMessage()).append(", actualParameters=").append(this.formatMap(this.actualParameters)).append(", paramNameInError=").append(this.paramNameInError).append(", paramProblem=").append(this.paramProblem).append(", getSourceException()=").append(this.getSourceException()).append("}");
        return builder.toString();
    }

    private String formatMap(Map<String, Object> actualParameters) {
        try {
            StringBuilder sb = new StringBuilder("{");
            sb.append(actualParameters.entrySet().stream().map(kv -> (String)kv.getKey() + "=" + (kv.getValue() != null && kv.getValue().getClass().isArray() ? Arrays.deepToString((Object[])kv.getValue()) : kv.getValue())).collect(Collectors.joining(", ")));
            sb.append("}");
            return sb.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "<unable to inspect actualParameters map>";
        }
    }
}

