/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.lang.impl;

import java.util.HashMap;
import java.util.Map;
import org.kie.dmn.feel.lang.impl.ExecutionFrame;
import org.kie.dmn.feel.util.EvalHelper;

public class ExecutionFrameImpl
implements ExecutionFrame {
    private ExecutionFrame parentFrame;
    private Map<String, Object> variables = new HashMap<String, Object>();

    public ExecutionFrameImpl(ExecutionFrame parentFrame) {
        this.parentFrame = parentFrame;
    }

    public ExecutionFrame getParentFrame() {
        return this.parentFrame;
    }

    public void setParentFrame(ExecutionFrame parentFrame) {
        this.parentFrame = parentFrame;
    }

    @Override
    public Object getValue(String symbol) {
        if (this.variables.containsKey(symbol = EvalHelper.normalizeVariableName(symbol))) {
            return this.variables.get(symbol);
        }
        if (this.parentFrame != null) {
            return this.parentFrame.getValue(symbol);
        }
        return null;
    }

    @Override
    public boolean isDefined(String symbol) {
        if (this.variables.containsKey(symbol = EvalHelper.normalizeVariableName(symbol))) {
            return true;
        }
        if (this.parentFrame != null) {
            return this.parentFrame.isDefined(symbol);
        }
        return false;
    }

    @Override
    public void setValue(String symbol, Object value) {
        this.variables.put(EvalHelper.normalizeVariableName(symbol), value);
    }

    @Override
    public Map<String, Object> getAllValues() {
        return this.variables;
    }
}

