/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions;

import java.math.BigDecimal;
import org.kie.dmn.feel.runtime.events.FEELEvent;
import org.kie.dmn.feel.runtime.events.InvalidParametersEvent;
import org.kie.dmn.feel.runtime.functions.BaseFEELFunction;
import org.kie.dmn.feel.runtime.functions.FEELFnResult;
import org.kie.dmn.feel.runtime.functions.ParameterName;
import org.kie.dmn.feel.util.EvalHelper;

public class StringLengthFunction
extends BaseFEELFunction {
    public StringLengthFunction() {
        super("string length");
    }

    public FEELFnResult<BigDecimal> invoke(@ParameterName(value="string") String string) {
        if (string == null) {
            return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "string", "cannot be null"));
        }
        return FEELFnResult.ofResult(EvalHelper.getBigDecimalOrNull(string.length()));
    }
}

