/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.kie.dmn.feel.lang.EvaluationContext;
import org.kie.dmn.feel.runtime.FEELFunction;
import org.kie.dmn.feel.runtime.events.FEELEvent;
import org.kie.dmn.feel.runtime.events.InvalidParametersEvent;
import org.kie.dmn.feel.runtime.functions.BaseFEELFunction;
import org.kie.dmn.feel.runtime.functions.FEELFnResult;
import org.kie.dmn.feel.runtime.functions.ParameterName;

public class SortFunction
extends BaseFEELFunction {
    public SortFunction() {
        super("sort");
    }

    public FEELFnResult<List<Object>> invoke(@ParameterName(value="ctx") EvaluationContext ctx, @ParameterName(value="list") List list, @ParameterName(value="precedes") FEELFunction function) {
        if (list == null) {
            return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "list", "cannot be null"));
        }
        if (function == null) {
            return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "precedes", "cannot be null"));
        }
        ArrayList newList = new ArrayList(list);
        AtomicBoolean hasError = new AtomicBoolean(false);
        newList.sort((a, b) -> {
            try {
                Object result = function.invokeReflectively(ctx, new Object[]{a, b});
                if (!(result instanceof Boolean) || ((Boolean)result).booleanValue()) {
                    return -1;
                }
                return 1;
            }
            catch (Throwable t) {
                hasError.set(true);
                return 0;
            }
        });
        if (hasError.get()) {
            return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "precedes", "raised an exception while sorting list " + list));
        }
        return FEELFnResult.ofResult(newList);
    }

    public FEELFnResult<List<Object>> invoke(@ParameterName(value="list") List list) {
        if (list == null) {
            return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "list", "cannot be null"));
        }
        ArrayList newList = new ArrayList(list);
        AtomicBoolean hasError = new AtomicBoolean(false);
        newList.sort((a, b) -> {
            try {
                if (a instanceof Comparable && b instanceof Comparable) {
                    return ((Comparable)a).compareTo(b);
                }
                return 0;
            }
            catch (Throwable t) {
                hasError.set(true);
                return 0;
            }
        });
        if (hasError.get()) {
            return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "list", "raised an exception while sorting by natural order"));
        }
        return FEELFnResult.ofResult(newList);
    }
}

