/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.kie.dmn.feel.lang.EvaluationContext;
import org.kie.dmn.feel.lang.Symbol;
import org.kie.dmn.feel.lang.impl.FEELEventListenersManager;
import org.kie.dmn.feel.lang.impl.NamedParameter;
import org.kie.dmn.feel.lang.types.FunctionSymbol;
import org.kie.dmn.feel.runtime.FEELFunction;
import org.kie.dmn.feel.runtime.events.FEELEvent;
import org.kie.dmn.feel.runtime.events.FEELEventBase;
import org.kie.dmn.feel.runtime.events.InvalidParametersEvent;
import org.kie.dmn.feel.runtime.functions.ParameterName;
import org.kie.dmn.feel.util.Either;
import org.kie.dmn.feel.util.EvalHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseFEELFunction
implements FEELFunction {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String name;
    private Symbol symbol;

    public BaseFEELFunction(String name) {
        this.name = name;
        this.symbol = new FunctionSymbol(name, this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        ((FunctionSymbol)this.symbol).setId(name);
    }

    @Override
    public Symbol getSymbol() {
        return this.symbol;
    }

    @Override
    public Object invokeReflectively(EvaluationContext ctx, Object[] params) {
        try {
            Object[] classes;
            boolean isNamedParams;
            boolean bl = isNamedParams = params.length > 0 && params[0] instanceof NamedParameter;
            if (!this.isCustomFunction()) {
                CandidateMethod cm;
                List<String> available = null;
                if (isNamedParams) {
                    available = Stream.of(params).map(p -> ((NamedParameter)p).getName()).collect(Collectors.toList());
                }
                if ((cm = this.getCandidateMethod(ctx, params, isNamedParams, available, (Class[])(classes = (Class[])Stream.of(params).map(p -> p != null ? p.getClass() : null).toArray(Class[]::new)))) != null) {
                    Object result = cm.apply.invoke((Object)this, cm.actualParams);
                    if (result instanceof Either) {
                        Either either = (Either)result;
                        Object eitherResult = either.cata(left -> {
                            FEELEventListenersManager.notifyListeners(ctx.getEventsManager(), () -> {
                                if (left instanceof InvalidParametersEvent) {
                                    InvalidParametersEvent invalidParametersEvent = (InvalidParametersEvent)left;
                                    invalidParametersEvent.setNodeName(this.getName());
                                    invalidParametersEvent.setActualParameters(Stream.of(cm.apply.getParameters()).map(p -> p.getAnnotation(ParameterName.class).value()).collect(Collectors.toList()), Arrays.asList(cm.actualParams));
                                }
                                return left;
                            });
                            return null;
                        }, Function.identity());
                        return eitherResult;
                    }
                    return result;
                }
            } else {
                Object result;
                if (isNamedParams) {
                    params = this.rearrangeParameters(params, this.getParameterNames().get(0));
                }
                if ((result = this.invoke(ctx, params)) instanceof Either) {
                    Either either = (Either)result;
                    Object[] usedParams = params;
                    Object eitherResult = either.cata(left -> {
                        FEELEventListenersManager.notifyListeners(ctx.getEventsManager(), () -> {
                            if (left instanceof InvalidParametersEvent) {
                                InvalidParametersEvent invalidParametersEvent = (InvalidParametersEvent)left;
                                invalidParametersEvent.setNodeName(this.getName());
                                invalidParametersEvent.setActualParameters(IntStream.of(0, usedParams.length).mapToObj(i -> "arg" + i).collect(Collectors.toList()), Arrays.asList(usedParams));
                            }
                            return left;
                        });
                        return null;
                    }, Function.identity());
                    return this.normalizeResult(eitherResult);
                }
                return this.normalizeResult(result);
            }
            String ps = Arrays.toString(classes);
            this.logger.error("Unable to find function '" + this.getName() + "( " + ps.substring(1, ps.length() - 1) + " )'");
            FEELEventListenersManager.notifyListeners(ctx.getEventsManager(), () -> new FEELEventBase(FEELEvent.Severity.ERROR, "Unable to find function '" + this.getName() + "( " + ps.substring(1, ps.length() - 1) + " )'", null));
        }
        catch (Exception e) {
            this.logger.error("Error trying to call function " + this.getName() + ".", (Throwable)e);
            FEELEventListenersManager.notifyListeners(ctx.getEventsManager(), () -> new FEELEventBase(FEELEvent.Severity.ERROR, "Error trying to call function " + this.getName() + ".", e));
        }
        return null;
    }

    public Object invoke(EvaluationContext ctx, Object[] params) {
        throw new RuntimeException("This method should be overriden by classes that implement custom feel functions");
    }

    private Object[] rearrangeParameters(Object[] params, List<String> pnames) {
        if (pnames.size() > 0) {
            Object[] actualParams = new Object[pnames.size()];
            block0: for (int i = 0; i < actualParams.length; ++i) {
                for (int j = 0; j < params.length; ++j) {
                    if (!((NamedParameter)params[j]).getName().equals(pnames.get(i))) continue;
                    actualParams[i] = ((NamedParameter)params[j]).getValue();
                    continue block0;
                }
            }
            params = actualParams;
        }
        return params;
    }

    private CandidateMethod getCandidateMethod(EvaluationContext ctx, Object[] params, boolean isNamedParams, List<String> available, Class[] classes) {
        CandidateMethod candidate = null;
        for (Method m : this.getClass().getDeclaredMethods()) {
            if (!m.getName().equals("invoke")) continue;
            Object[] actualParams = null;
            boolean injectCtx = Arrays.stream(m.getParameterTypes()).anyMatch(p -> EvaluationContext.class.isAssignableFrom((Class<?>)p));
            if (injectCtx) {
                actualParams = new Object[params.length + 1];
                int j = 0;
                for (int i = 0; i < m.getParameterCount() && j < params.length; ++i) {
                    if (EvaluationContext.class.isAssignableFrom(m.getParameterTypes()[i])) {
                        if (isNamedParams) {
                            actualParams[i] = new NamedParameter("ctx", ctx);
                            continue;
                        }
                        actualParams[i] = ctx;
                        continue;
                    }
                    actualParams[i] = params[j];
                    ++j;
                }
            } else {
                actualParams = params;
            }
            if (isNamedParams && (actualParams = this.calculateActualParams(ctx, m, actualParams, available)) == null) continue;
            CandidateMethod cm = new CandidateMethod(actualParams);
            Class<?>[] parameterTypes = m.getParameterTypes();
            this.adjustForVariableParameters(cm, parameterTypes);
            if (parameterTypes.length != cm.getActualParams().length) continue;
            boolean found = true;
            for (int i = 0; i < parameterTypes.length; ++i) {
                if (cm.getActualClasses()[i] == null || parameterTypes[i].isAssignableFrom(cm.getActualClasses()[i])) continue;
                found = false;
                break;
            }
            if (!found) continue;
            cm.setApply(m);
            if (candidate != null && cm.getScore() <= candidate.getScore()) continue;
            candidate = cm;
        }
        return candidate;
    }

    @Override
    public List<List<String>> getParameterNames() {
        return Collections.emptyList();
    }

    private void adjustForVariableParameters(CandidateMethod cm, Class<?>[] parameterTypes) {
        if (parameterTypes.length > 0 && parameterTypes[parameterTypes.length - 1].isArray()) {
            Object[] remaining;
            Object[] newParams = new Object[parameterTypes.length];
            if (newParams.length > 1) {
                System.arraycopy(cm.getActualParams(), 0, newParams, 0, newParams.length - 1);
            }
            newParams[newParams.length - 1] = remaining = new Object[cm.getActualParams().length - parameterTypes.length + 1];
            System.arraycopy(cm.getActualParams(), parameterTypes.length - 1, remaining, 0, remaining.length);
            cm.setActualParams(newParams);
        }
    }

    private Object[] calculateActualParams(EvaluationContext ctx, Method m, Object[] params, List<String> available) {
        Annotation[][] pas = m.getParameterAnnotations();
        ArrayList<String> names = new ArrayList<String>(m.getParameterCount());
        for (int i = 0; i < m.getParameterCount(); ++i) {
            int p = 0;
            while (p < pas[i].length) {
                if (pas[i][p] instanceof ParameterName) {
                    names.add(((ParameterName)pas[i][p]).value());
                    break;
                }
                ++i;
            }
            if (names.get(i) != null) continue;
            return null;
        }
        if (names.containsAll(available)) {
            Object[] actualParams = new Object[names.size()];
            for (Object o : params) {
                NamedParameter np = (NamedParameter)o;
                actualParams[names.indexOf((Object)np.getName())] = np.getValue();
            }
            return actualParams;
        }
        return null;
    }

    private Object normalizeResult(Object result) {
        return result != null && result instanceof Number && !(result instanceof BigDecimal) ? EvalHelper.getBigDecimalOrNull(result.toString()) : result;
    }

    protected boolean isCustomFunction() {
        return false;
    }

    private static class CandidateMethod {
        private Method apply = null;
        private Object[] actualParams = null;
        private Class[] actualClasses = null;
        private int score;

        public CandidateMethod(Object[] actualParams) {
            this.actualParams = actualParams;
            this.populateActualClasses();
        }

        private void calculateScore() {
            this.score = this.actualClasses.length > 0 && this.actualClasses[this.actualClasses.length - 1] != null && this.actualClasses[this.actualClasses.length - 1].isArray() ? 1 : 10;
        }

        public Method getApply() {
            return this.apply;
        }

        public void setApply(Method apply) {
            this.apply = apply;
            this.calculateScore();
        }

        public Object[] getActualParams() {
            return this.actualParams;
        }

        public void setActualParams(Object[] actualParams) {
            this.actualParams = actualParams;
            this.populateActualClasses();
        }

        private void populateActualClasses() {
            this.actualClasses = (Class[])Stream.of(this.actualParams).map(p -> p != null ? p.getClass() : null).toArray(Class[]::new);
        }

        public Class[] getActualClasses() {
            return this.actualClasses;
        }

        public int getScore() {
            return this.score;
        }
    }
}

