/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.lang.ast;

import org.antlr.v4.runtime.ParserRuleContext;
import org.kie.dmn.feel.lang.EvaluationContext;
import org.kie.dmn.feel.lang.ast.BaseNode;
import org.kie.dmn.feel.lang.ast.ListNode;
import org.kie.dmn.feel.lang.ast.NameRefNode;
import org.kie.dmn.feel.lang.ast.QualifiedNameNode;
import org.kie.dmn.feel.runtime.FEELFunction;
import org.kie.dmn.feel.runtime.UnaryTest;
import org.kie.dmn.feel.runtime.events.FEELEvent;
import org.kie.dmn.feel.util.Msg;

public class FunctionInvocationNode
extends BaseNode {
    private BaseNode name;
    private ListNode params;

    public FunctionInvocationNode(ParserRuleContext ctx, BaseNode name, ListNode params) {
        super(ctx);
        this.name = name;
        this.params = params;
    }

    public BaseNode getName() {
        return this.name;
    }

    public void setName(BaseNode name) {
        this.name = name;
    }

    public ListNode getParams() {
        return this.params;
    }

    public void setParams(ListNode params) {
        this.params = params;
    }

    @Override
    public Object evaluate(EvaluationContext ctx) {
        Object p;
        FEELFunction function = null;
        Object value = null;
        if (this.name instanceof NameRefNode) {
            value = ctx.getValue(this.name.getText());
        } else {
            QualifiedNameNode qn = (QualifiedNameNode)this.name;
            String[] qns = qn.getPartsAsStringArray();
            value = ctx.getValue(qns);
        }
        if (value instanceof FEELFunction) {
            function = (FEELFunction)value;
            if (function != null) {
                p = this.params.getElements().stream().map(e -> e.evaluate(ctx)).toArray(Object[]::new);
                Object result = function.invokeReflectively(ctx, (Object[])p);
                return result;
            }
            ctx.notifyEvt(this.astEvent(FEELEvent.Severity.ERROR, Msg.createMessage(Msg.FUNCTION_NOT_FOUND, this.name.getText())));
        } else if (value instanceof UnaryTest) {
            if (this.params.getElements().size() == 1) {
                p = this.params.getElements().get(0).evaluate(ctx);
                return ((UnaryTest)value).apply(ctx, p);
            }
            ctx.notifyEvt(this.astEvent(FEELEvent.Severity.ERROR, Msg.createMessage(Msg.CAN_T_INVOKE_AN_UNARY_TEST_WITH_S_PARAMETERS_UNARY_TESTS_REQUIRE_1_SINGLE_PARAMETER, this.params.getElements().size())));
        }
        return null;
    }
}

