/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.lang.ast;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.v4.runtime.ParserRuleContext;
import org.kie.dmn.feel.lang.EvaluationContext;
import org.kie.dmn.feel.lang.ast.BaseNode;
import org.kie.dmn.feel.lang.types.BuiltInType;
import org.kie.dmn.feel.runtime.events.FEELEvent;
import org.kie.dmn.feel.util.Msg;

public class FilterExpressionNode
extends BaseNode {
    private BaseNode expression;
    private BaseNode filter;

    public FilterExpressionNode(ParserRuleContext ctx, BaseNode expression, BaseNode filter) {
        super(ctx);
        this.expression = expression;
        this.filter = filter;
    }

    public BaseNode getExpression() {
        return this.expression;
    }

    public void setExpression(BaseNode expression) {
        this.expression = expression;
    }

    public BaseNode getFilter() {
        return this.filter;
    }

    public void setFilter(BaseNode filter) {
        this.filter = filter;
    }

    @Override
    public Object evaluate(EvaluationContext ctx) {
        Object value = this.expression.evaluate(ctx);
        List<Object> list = value instanceof List ? (List<Object>)value : Arrays.asList(value);
        try {
            if (this.filter.getResultType() != BuiltInType.BOOLEAN) {
                Object f = this.filter.evaluate(ctx);
                if (f != null && f instanceof Number) {
                    int i = ((Number)f).intValue();
                    if (i > 0 && i <= list.size()) {
                        return list.get(i - 1);
                    }
                    if (i < 0 && Math.abs(i) <= list.size()) {
                        return list.get(list.size() + i);
                    }
                    ctx.notifyEvt(this.astEvent(FEELEvent.Severity.ERROR, Msg.createMessage(Msg.INDEX_OUT_OF_BOUND)));
                    return null;
                }
                ArrayList results = new ArrayList();
                for (Object v : list) {
                    this.evaluateExpressionInContext(ctx, results, v);
                }
                return results;
            }
            ArrayList results = new ArrayList();
            for (Object v : list) {
                this.evaluateExpressionInContext(ctx, results, v);
            }
            return results;
        }
        catch (Exception e) {
            ctx.notifyEvt(this.astEvent(FEELEvent.Severity.ERROR, Msg.createMessage(Msg.ERROR_EXECUTING_LIST_FILTER, this.getText()), e));
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evaluateExpressionInContext(EvaluationContext ctx, List results, Object v) {
        try {
            Object r;
            ctx.enterFrame();
            ctx.setValue("item", v);
            if (v instanceof Map) {
                Set set = ((Map)v).entrySet();
                for (Map.Entry ce : set) {
                    if (!(ce.getKey() instanceof String)) continue;
                    ctx.setValue((String)ce.getKey(), ce.getValue());
                }
            }
            if ((r = this.filter.evaluate(ctx)) instanceof Boolean && (Boolean)r == Boolean.TRUE) {
                results.add(v);
            }
        }
        finally {
            ctx.exitFrame();
        }
    }
}

