/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core.internal.utils;

import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNMetadata;
import org.kie.dmn.core.impl.DMNMetadataImpl;

public class MapBackedDMNContext
implements DMNContext {
    private Deque<ScopeReference> stack = new LinkedList<ScopeReference>();
    private Map<String, Object> ctx;
    private DMNMetadata metadata;

    private MapBackedDMNContext() {
        this.ctx = new HashMap<String, Object>();
        this.metadata = new DMNMetadataImpl();
    }

    private MapBackedDMNContext(Map<String, Object> ctx) {
        this.ctx = new HashMap<String, Object>(ctx);
        this.metadata = new DMNMetadataImpl();
    }

    private MapBackedDMNContext(Map<String, Object> ctx, Map<String, Object> metadata) {
        this.ctx = new HashMap<String, Object>(ctx);
        this.metadata = new DMNMetadataImpl(metadata);
    }

    public static MapBackedDMNContext of(Map<String, Object> ctx) {
        return new MapBackedDMNContext(ctx);
    }

    public static MapBackedDMNContext of(Map<String, Object> ctx, Map<String, Object> metadata) {
        return new MapBackedDMNContext(ctx, metadata);
    }

    public DMNContext clone() {
        return MapBackedDMNContext.of(this.ctx, this.metadata.asMap());
    }

    public Object set(String name, Object value) {
        return this.getCurrentEntries().put(name, value);
    }

    public Object get(String name) {
        return this.getCurrentEntries().get(name);
    }

    private Map<String, Object> getCurrentEntries() {
        if (this.stack.isEmpty()) {
            return this.ctx;
        }
        return this.stack.peek().getRef();
    }

    public void pushScope(String name, String namespace) {
        Map scopeRef = (Map)this.getCurrentEntries().computeIfAbsent(name, s -> new LinkedHashMap());
        this.stack.push(new ScopeReference(name, namespace, scopeRef));
    }

    public void popScope() {
        this.stack.pop();
    }

    public Optional<String> scopeNamespace() {
        if (this.stack.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.stack.peek().getNamespace());
    }

    public Map<String, Object> getAll() {
        return this.getCurrentEntries();
    }

    public boolean isDefined(String name) {
        return this.getCurrentEntries().containsKey(name);
    }

    public DMNMetadata getMetadata() {
        return this.metadata;
    }

    public static class ScopeReference {
        private final String name;
        private final String namespace;
        private final Map<String, Object> ref;

        public ScopeReference(String name, String namespace, Map<String, Object> ref) {
            this.name = name;
            this.namespace = namespace;
            this.ref = ref;
        }

        public String getName() {
            return this.name;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public Map<String, Object> getRef() {
            return this.ref;
        }
    }
}

