/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core.compiler.execmodelbased;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Map;
import org.kie.dmn.core.compiler.DMNFEELHelper;
import org.kie.dmn.core.compiler.execmodelbased.DTableModel;
import org.kie.dmn.core.compiler.execmodelbased.FeelExpressionSourceGenerator;
import org.kie.dmn.core.impl.DMNModelImpl;
import org.kie.dmn.feel.codegen.feel11.CompiledFEELExpression;
import org.kie.dmn.feel.lang.CompilerContext;
import org.kie.dmn.model.api.DecisionTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecModelDTableModel
extends DTableModel {
    private static final Logger logger = LoggerFactory.getLogger(ExecModelDTableModel.class);
    private final Class<?> clazz;

    public ExecModelDTableModel(DMNFEELHelper feel, DMNModelImpl model, String dtName, String tableName, DecisionTable dt, Class<?> feelExpressionClass) {
        super(feel, model, dtName, tableName, dt);
        this.clazz = feelExpressionClass;
    }

    @Override
    protected void initRows(CompilerContext feelctx, Map<String, CompiledFEELExpression> compilationCache) {
        logger.debug("Reading " + this.rows.size() + " rows from class loader");
        CompiledFEELExpression[][] array = (CompiledFEELExpression[][])this.readFieldWithRuntimeCheck("FEEL_EXPRESSION_ARRAY");
        for (int i = 0; i < this.rows.size(); ++i) {
            DTableModel.DRowModel row = (DTableModel.DRowModel)this.rows.get(i);
            row.compiledOutputs = Arrays.asList(array[i]);
        }
    }

    @Override
    protected void initInputClauses(CompilerContext feelctx, Map<String, CompiledFEELExpression> compilationCache) {
        logger.debug("Reading " + this.columns.size() + " columns from class loader");
        this.iterateOverInputClauses((column, index) -> {
            column.compiledInputClause = (CompiledFEELExpression)this.readFieldWithRuntimeCheck(FeelExpressionSourceGenerator.instanceName("InputClause" + index));
        });
    }

    @Override
    protected void initOutputClauses(CompilerContext feelctx, Map<String, CompiledFEELExpression> compilationCache) {
        logger.debug("Reading " + this.outputs.size() + " outputs from class loader");
        this.iterateOverOutputClauses((output, defaultValue) -> {
            output.compiledDefault = (CompiledFEELExpression)this.readFieldWithRuntimeCheck(FeelExpressionSourceGenerator.instanceName(FeelExpressionSourceGenerator.getOutputName(defaultValue)));
        });
    }

    private Object readFieldWithRuntimeCheck(String fieldName) {
        try {
            Field field = this.clazz.getField(fieldName);
            return field.get(this.clazz);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

