/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core.jsr223;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import org.kie.dmn.api.core.ast.DMNNode;
import org.kie.dmn.core.api.DMNExpressionEvaluator;
import org.kie.dmn.core.ast.DMNBaseNode;
import org.kie.dmn.core.compiler.DMNCompilerContext;
import org.kie.dmn.core.compiler.DMNCompilerImpl;
import org.kie.dmn.core.compiler.DMNEvaluatorCompiler;
import org.kie.dmn.core.impl.DMNModelImpl;
import org.kie.dmn.core.jsr223.JSR223DTExpressionEvaluator;
import org.kie.dmn.core.jsr223.JSR223LiteralExpressionEvaluator;
import org.kie.dmn.core.jsr223.JSR223ScriptEngineEvaluator;
import org.kie.dmn.model.api.DecisionRule;
import org.kie.dmn.model.api.DecisionTable;
import org.kie.dmn.model.api.Expression;
import org.kie.dmn.model.api.InputClause;
import org.kie.dmn.model.api.LiteralExpression;
import org.kie.dmn.model.api.UnaryTests;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSR223EvaluatorCompiler
extends DMNEvaluatorCompiler {
    private static final Logger LOG = LoggerFactory.getLogger(JSR223EvaluatorCompiler.class);
    private final ScriptEngineManager SEMANAGER = new ScriptEngineManager();

    public JSR223EvaluatorCompiler(DMNCompilerImpl compiler) {
        super(compiler);
        LOG.debug("ScriptEngineFactories:");
        for (ScriptEngineFactory factory : this.SEMANAGER.getEngineFactories()) {
            this.printScriptEngineFactoryInfo(factory);
        }
    }

    public DMNExpressionEvaluator compileExpression(DMNCompilerContext ctx, DMNModelImpl model, DMNBaseNode node, String exprName, Expression expression) {
        if (expression instanceof LiteralExpression) {
            return this.compileLiteralExpr(ctx, model, node, exprName, (LiteralExpression)expression);
        }
        if (expression instanceof DecisionTable) {
            return this.compileDecisionTable(ctx, model, node, exprName, (DecisionTable)expression);
        }
        return super.compileExpression(ctx, model, node, exprName, expression);
    }

    protected DMNExpressionEvaluator compileDecisionTable(DMNCompilerContext ctx, DMNModelImpl model, DMNBaseNode node, String dtName, DecisionTable dt) {
        if (model.getDefinitions().getExpressionLanguage().equals(model.getDefinitions().getURIFEEL())) {
            return super.compileDecisionTable(ctx, model, node, dtName, dt);
        }
        LOG.debug("exprLanguage {}", (Object)model.getDefinitions().getExpressionLanguage());
        ArrayList<JSR223LiteralExpressionEvaluator> ins = new ArrayList<JSR223LiteralExpressionEvaluator>();
        for (InputClause input : dt.getInput()) {
            LiteralExpression inExpr = input.getInputExpression();
            this.normalizeLiteralExpressionInTable(model, inExpr);
            JSR223LiteralExpressionEvaluator inLiteralExpr = (JSR223LiteralExpressionEvaluator)this.compileLiteralExpr(ctx, model, node, dtName, inExpr);
            ins.add(inLiteralExpr);
        }
        if (dt.getOutput().size() != 1) {
            throw new UnsupportedOperationException("In JSR223 context, the DecisionTable must have only 1 output; for composite, use natural idiom of the expression language, eg: `{\"a\":1, \"b\":2}` etc.");
        }
        ArrayList<JSR223DTExpressionEvaluator.JSR223Rule> rules = new ArrayList<JSR223DTExpressionEvaluator.JSR223Rule>();
        for (DecisionRule rule : dt.getRule()) {
            ArrayList<JSR223ScriptEngineEvaluator> ruleTests = new ArrayList<JSR223ScriptEngineEvaluator>();
            for (UnaryTests ie : rule.getInputEntry()) {
                this.normalizeUnaryTestsInTable(model, ie);
                JSR223ScriptEngineEvaluator ruleTest = this.compileUnaryTests(ctx, model, node, dtName, ie);
                ruleTests.add(ruleTest);
            }
            if (rule.getOutputEntry().size() != 1) {
                throw new IllegalStateException("inconsistent with OutputClause size.");
            }
            LiteralExpression outExpr = (LiteralExpression)rule.getOutputEntry().get(0);
            this.normalizeLiteralExpressionInTable(model, outExpr);
            JSR223LiteralExpressionEvaluator outLiteralExpr = (JSR223LiteralExpressionEvaluator)this.compileLiteralExpr(ctx, model, node, dtName, outExpr);
            rules.add(new JSR223DTExpressionEvaluator.JSR223Rule(ruleTests, outLiteralExpr));
        }
        return new JSR223DTExpressionEvaluator((DMNNode)node, dt, ins, rules);
    }

    private JSR223ScriptEngineEvaluator compileUnaryTests(DMNCompilerContext ctx, DMNModelImpl model, DMNBaseNode node, String exprName, UnaryTests expression) {
        ScriptEngine efEngine = this.getScriptEngine(expression.getExpressionLanguage());
        return new JSR223ScriptEngineEvaluator(efEngine, expression.getText());
    }

    private void normalizeUnaryTestsInTable(DMNModelImpl model, UnaryTests ut) {
        if (!Optional.ofNullable(ut.getExpressionLanguage()).orElse("").isEmpty()) {
            throw new UnsupportedOperationException("In JSR223 context, the DecisionTable must be consistent in the expressionLanguage of its constituents elements (inputClause, outputClause, Rule)");
        }
        ut.setExpressionLanguage(model.getDefinitions().getExpressionLanguage());
    }

    private void normalizeLiteralExpressionInTable(DMNModelImpl model, LiteralExpression lExpr) {
        if (!Optional.ofNullable(lExpr.getExpressionLanguage()).orElse("").isEmpty()) {
            throw new UnsupportedOperationException("In JSR223 context, the DecisionTable must be consistent in the expressionLanguage of its constituents elements (inputClause, outputClause, Rule)");
        }
        lExpr.setExpressionLanguage(model.getDefinitions().getExpressionLanguage());
    }

    protected DMNExpressionEvaluator compileLiteralExpr(DMNCompilerContext ctx, DMNModelImpl model, DMNBaseNode node, String exprName, LiteralExpression expression) {
        String exprLanguage = Optional.ofNullable(expression.getExpressionLanguage()).orElse(model.getDefinitions().getExpressionLanguage());
        if (!exprLanguage.equals(model.getDefinitions().getURIFEEL())) {
            LOG.debug("exprLanguage {}", (Object)exprLanguage);
            ScriptEngine efEngine = this.getScriptEngine(exprLanguage);
            JSR223ScriptEngineEvaluator eval = new JSR223ScriptEngineEvaluator(efEngine, expression.getText());
            return new JSR223LiteralExpressionEvaluator(eval);
        }
        return super.compileExpression(ctx, model, node, exprName, (Expression)expression);
    }

    private ScriptEngine getScriptEngine(String exprLanguage) {
        ScriptEngine engine = this.SEMANAGER.getEngineByName(exprLanguage);
        if (engine == null) {
            throw new IllegalStateException("was unable to locate scripting engine: " + exprLanguage);
        }
        LOG.debug("Selected ScriptEngine: {}", (Object)engine.getFactory().getEngineName());
        return engine;
    }

    private void printScriptEngineFactoryInfo(ScriptEngineFactory factory) {
        String engName = factory.getEngineName();
        String engVersion = factory.getEngineVersion();
        String langName = factory.getLanguageName();
        String langVersion = factory.getLanguageVersion();
        LOG.debug("Script Engine: {} {} {} {}", new Object[]{engName, engVersion, langName, langVersion});
        List<String> engNames = factory.getNames();
        for (String name : engNames) {
            LOG.debug("\tEngine Alias: {}", (Object)name);
        }
    }
}

