/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core.jsr223;

import java.math.BigDecimal;

public class JSR223Utils {
    private JSR223Utils() {
    }

    public static double doubleValueExact(BigDecimal original) {
        double result = original.doubleValue();
        if (!Double.isNaN(result) && !Double.isInfinite(result) && new BigDecimal(String.valueOf(result)).compareTo(original) == 0) {
            return result;
        }
        throw new ArithmeticException(String.format("Conversion of %s incurred in loss of precision from BigDecimal", original));
    }

    public static String escapeIdentifierForBinding(String original) {
        StringBuilder sb = new StringBuilder(original.length());
        Iterable iterable = original.codePoints()::iterator;
        int i = 0;
        for (Integer cp : iterable) {
            if (i == 0 && cp >= 48 && cp <= 57) {
                sb.append("_");
            }
            if (cp >= 48 && cp <= 57) {
                sb.append((char)cp.intValue());
            } else if (cp >= 97 && cp <= 122) {
                sb.append((char)cp.intValue());
            } else if (cp >= 65 && cp <= 90) {
                sb.append((char)cp.intValue());
            } else {
                sb.append("_");
            }
            ++i;
        }
        return sb.toString();
    }
}

