/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core.jsr223;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.kie.dmn.core.jsr223.JSR223Utils;
import org.kie.dmn.feel.runtime.FEELFunction;
import org.kie.dmn.feel.util.EvalHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSR223ScriptEngineEvaluator {
    public static final String DMN_UNARYTEST_SYMBOL = "DMN_UNARYTEST_SYMBOL";
    public static final String DMN_SYMBOL_ESCAPE_BOOL = "DMN_SYMBOL_ESCAPE_BOOL";
    private static final Logger LOG = LoggerFactory.getLogger(JSR223ScriptEngineEvaluator.class);
    private final ScriptEngine scriptEngine;
    private final String expression;
    private final Function<String, String> keyEscapeFn;

    public JSR223ScriptEngineEvaluator(ScriptEngine scriptEngine, String expression) {
        this.scriptEngine = scriptEngine;
        this.expression = expression;
        boolean shouldEscape = Boolean.valueOf(Optional.ofNullable(this.scriptEngine.getFactory().getParameter(DMN_SYMBOL_ESCAPE_BOOL)).map(Object::toString).orElse("false"));
        this.keyEscapeFn = shouldEscape ? JSR223Utils::escapeIdentifierForBinding : Function.identity();
    }

    public Object eval(Map<String, Object> ins) throws ScriptException {
        Bindings engineScope = this.createBindings(ins);
        Object result = this.scriptEngine.eval(this.expression, engineScope);
        LOG.debug("Script eval of '{}' result: {}", (Object)this.expression, result);
        return EvalHelper.coerceNumber((Object)result);
    }

    public boolean test(Object in, Map<String, Object> context) throws ScriptException {
        Bindings engineScope = this.createBindings(context);
        String keyForUnaryTest = Optional.ofNullable(this.scriptEngine.getFactory().getParameter(DMN_UNARYTEST_SYMBOL).toString()).orElse("_");
        engineScope.put(keyForUnaryTest, in);
        Object result = this.scriptEngine.eval(this.expression, engineScope);
        LOG.debug("Script test of '{}' result: {}", (Object)this.expression, result);
        return result == Boolean.TRUE;
    }

    private Bindings createBindings(Map<String, Object> ins) {
        Bindings engineScope = this.scriptEngine.createBindings();
        HashMap<String, Object> _context = new HashMap<String, Object>();
        engineScope.put("_context", (Object)_context);
        for (Map.Entry<String, Object> kv : ins.entrySet()) {
            String key = this.keyEscapeFn.apply(kv.getKey());
            Object value = kv.getValue();
            if (value instanceof BigDecimal) {
                value = JSR223Utils.doubleValueExact((BigDecimal)value);
            }
            if (value instanceof FEELFunction) {
                LOG.trace("SKIP binding {} of {}", (Object)key, value);
                continue;
            }
            LOG.trace("Setting binding {} to {}", (Object)key, value);
            engineScope.put(key, value);
            _context.put(kv.getKey(), value);
        }
        return engineScope;
    }
}

