/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core.jsr223;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.script.ScriptException;
import org.drools.model.functions.Function1;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.api.core.ast.DMNNode;
import org.kie.dmn.api.core.event.DMNRuntimeEventManager;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.api.feel.runtime.events.FEELEventListener;
import org.kie.dmn.core.api.DMNExpressionEvaluator;
import org.kie.dmn.core.api.EvaluatorResult;
import org.kie.dmn.core.ast.DMNDTExpressionEvaluator;
import org.kie.dmn.core.ast.EvaluatorResultImpl;
import org.kie.dmn.core.compiler.alphanetbased.Results;
import org.kie.dmn.core.impl.DMNResultImpl;
import org.kie.dmn.core.impl.DMNRuntimeEventManagerUtils;
import org.kie.dmn.core.jsr223.JSR223LiteralExpressionEvaluator;
import org.kie.dmn.core.jsr223.JSR223ScriptEngineEvaluator;
import org.kie.dmn.feel.lang.EvaluationContext;
import org.kie.dmn.feel.runtime.decisiontables.DecisionTable;
import org.kie.dmn.feel.runtime.decisiontables.HitPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSR223DTExpressionEvaluator
implements DMNExpressionEvaluator {
    private static Logger LOG = LoggerFactory.getLogger(JSR223DTExpressionEvaluator.class);
    private final DMNNode node;
    private final org.kie.dmn.model.api.DecisionTable dt;
    private final List<JSR223LiteralExpressionEvaluator> ins;
    private final List<JSR223Rule> rules;
    private final HitPolicy hitPolicy;
    private final DecisionTable decisionTableModel;

    public JSR223DTExpressionEvaluator(DMNNode node, org.kie.dmn.model.api.DecisionTable dt, List<JSR223LiteralExpressionEvaluator> ins, List<JSR223Rule> rules) {
        this.node = node;
        this.dt = dt;
        this.ins = ins;
        this.rules = rules;
        String policy = dt.getHitPolicy().value() + (dt.getAggregation() != null ? " " + dt.getAggregation().value() : "");
        this.hitPolicy = HitPolicy.fromString((String)policy);
        this.decisionTableModel = new JSR223WrappingDecisionTable(node.getName());
    }

    public EvaluatorResult evaluate(DMNRuntimeEventManager dmrem, DMNResult dmnr) {
        EvaluatorResultImpl evaluatorResultImpl;
        ArrayList<FEELEvent> events = new ArrayList<FEELEvent>();
        DMNResultImpl result = (DMNResultImpl)dmnr;
        DMNDTExpressionEvaluator.EventResults r = null;
        try {
            DMNRuntimeEventManagerUtils.fireBeforeEvaluateDecisionTable((DMNRuntimeEventManager)dmrem, (String)this.node.getName(), (String)this.node.getName(), (DMNResult)result);
            Map contextValues = result.getContext().getAll();
            ArrayList<Object> params = new ArrayList<Object>(this.ins.size());
            for (JSR223LiteralExpressionEvaluator in : this.ins) {
                params.add(in.getEval().eval(contextValues));
            }
            Results results = new Results();
            for (int rIndex = 0; rIndex < this.rules.size(); ++rIndex) {
                JSR223ScriptEngineEvaluator test;
                JSR223Rule rule = this.rules.get(rIndex);
                boolean match = true;
                for (int i = 0; i < params.size() && (match &= (test = rule.ruleTests.get(i)).test(params.get(i), contextValues)); ++i) {
                }
                if (!match) continue;
                results.addResult(rIndex, "", (Function1)new Fn(rule.outLiteralExpr.getEval()));
            }
            Object dtr = results.applyHitPolicy((EvaluationContext)new JSR223WrappingEC(contextValues, events), this.hitPolicy, this.decisionTableModel);
            r = DMNDTExpressionEvaluator.processEvents(events, (DMNRuntimeEventManager)dmrem, (DMNResultImpl)result, (DMNNode)this.node);
            evaluatorResultImpl = new EvaluatorResultImpl(dtr, r.hasErrors ? EvaluatorResult.ResultType.FAILURE : EvaluatorResult.ResultType.SUCCESS);
        }
        catch (ScriptException e) {
            try {
                LOG.debug("failed evaluate", (Throwable)e);
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                DMNRuntimeEventManagerUtils.fireAfterEvaluateDecisionTable((DMNRuntimeEventManager)dmrem, (String)this.node.getName(), (String)this.node.getName(), (DMNResult)result, (List)(r != null ? r.matchedRules : null), (List)(r != null ? r.fired : null));
                throw throwable;
            }
        }
        DMNRuntimeEventManagerUtils.fireAfterEvaluateDecisionTable((DMNRuntimeEventManager)dmrem, (String)this.node.getName(), (String)this.node.getName(), (DMNResult)result, (List)(r != null ? r.matchedRules : null), (List)(r != null ? r.fired : null));
        return evaluatorResultImpl;
    }

    private static class JSR223WrappingEC
    implements EvaluationContext {
        private final Map<String, Object> values;
        private final List<FEELEvent> events;

        public JSR223WrappingEC(Map<String, Object> values, List<FEELEvent> events) {
            this.values = Collections.unmodifiableMap(values);
            this.events = events;
        }

        public void enterFrame() {
            throw new UnsupportedOperationException("not implemented for this impl.");
        }

        public void exitFrame() {
            throw new UnsupportedOperationException("not implemented for this impl.");
        }

        public EvaluationContext current() {
            throw new UnsupportedOperationException("not implemented for this impl.");
        }

        public void setValue(String name, Object value) {
            throw new UnsupportedOperationException("not implemented for this impl.");
        }

        public Object getValue(String name) {
            return this.values.get(name);
        }

        public Object getValue(String[] name) {
            throw new UnsupportedOperationException("not implemented for this impl.");
        }

        public boolean isDefined(String name) {
            return this.values.containsKey(name);
        }

        public boolean isDefined(String[] name) {
            throw new UnsupportedOperationException("not implemented for this impl.");
        }

        public Map<String, Object> getAllValues() {
            return this.values;
        }

        public DMNRuntime getDMNRuntime() {
            throw new UnsupportedOperationException("not implemented for this impl.");
        }

        public ClassLoader getRootClassLoader() {
            throw new UnsupportedOperationException("not implemented for this impl.");
        }

        public void notifyEvt(Supplier<FEELEvent> event) {
            this.events.add(event.get());
        }

        public Collection<FEELEventListener> getListeners() {
            throw new UnsupportedOperationException("not implemented for this impl.");
        }

        public void setRootObject(Object v) {
            throw new UnsupportedOperationException("not implemented for this impl.");
        }

        public Object getRootObject() {
            throw new UnsupportedOperationException("not implemented for this impl.");
        }
    }

    private static class JSR223WrappingDecisionTable
    implements DecisionTable {
        private final String name;

        public JSR223WrappingDecisionTable(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public List<? extends DecisionTable.OutputClause> getOutputs() {
            return Collections.emptyList();
        }
    }

    public static class Fn
    implements Function1<EvaluationContext, Object> {
        private final JSR223ScriptEngineEvaluator eval;

        public Fn(JSR223ScriptEngineEvaluator eval) {
            this.eval = eval;
        }

        public Object apply(EvaluationContext ctx) {
            try {
                return this.eval.eval(ctx.getAllValues());
            }
            catch (ScriptException e) {
                LOG.debug("failed Fn eval", (Throwable)e);
                return null;
            }
        }
    }

    public static class JSR223Rule {
        public final List<JSR223ScriptEngineEvaluator> ruleTests;
        public final JSR223LiteralExpressionEvaluator outLiteralExpr;

        public JSR223Rule(List<JSR223ScriptEngineEvaluator> ruleTests, JSR223LiteralExpressionEvaluator outLiteralExpr) {
            this.ruleTests = ruleTests;
            this.outLiteralExpr = outLiteralExpr;
        }
    }
}

