/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core.jsr223.jq;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import javax.script.AbstractScriptEngine;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import net.thisptr.jackson.jq.BuiltinFunctionLoader;
import net.thisptr.jackson.jq.JsonQuery;
import net.thisptr.jackson.jq.Scope;
import net.thisptr.jackson.jq.Version;
import net.thisptr.jackson.jq.Versions;
import org.kie.dmn.core.jsr223.jq.JQScriptEngineFactory;

public class JQScriptEngine
extends AbstractScriptEngine {
    public static final String DMN_UNARYTEST_SYMBOL = "DMN_UNARYTEST_SYMBOL";
    public static final String DMN_UNARYTEST_SYMBOL_VALUE = ".";
    public static final String DMN_SYMBOL_ESCAPE_BOOL = "DMN_SYMBOL_ESCAPE_BOOL";
    private final ScriptEngineFactory factory;
    private final ObjectMapper MAPPER = ((JsonMapper.Builder)JsonMapper.builder().addModule((Module)new JavaTimeModule())).build();

    JQScriptEngine(JQScriptEngineFactory factory) {
        this.factory = factory;
    }

    @Override
    public Object eval(String script, ScriptContext context) throws ScriptException {
        try {
            JsonNode in;
            Bindings bindings = context.getBindings(100);
            Scope rootScope = Scope.newEmptyScope();
            BuiltinFunctionLoader.getInstance().loadFunctions(Versions.JQ_1_6, rootScope);
            Scope childScope = Scope.newChildScope((Scope)rootScope);
            if (bindings.containsKey(DMN_UNARYTEST_SYMBOL_VALUE)) {
                for (Map.Entry kv : bindings.entrySet()) {
                    if (((String)kv.getKey()).equals(DMN_UNARYTEST_SYMBOL_VALUE)) continue;
                    childScope.setValue((String)kv.getKey(), this.MAPPER.valueToTree(kv.getValue()));
                }
                in = this.MAPPER.valueToTree(bindings.get(DMN_UNARYTEST_SYMBOL_VALUE));
            } else {
                in = this.MAPPER.valueToTree((Object)bindings);
            }
            JsonQuery q = JsonQuery.compile((String)script, (Version)Versions.JQ_1_6);
            ArrayList out = new ArrayList();
            q.apply(childScope, in, out::add);
            JsonNode outNode = (JsonNode)out.get(0);
            Object result = null;
            if (!outNode.isValueNode()) {
                result = this.MAPPER.treeToValue((TreeNode)outNode, Map.class);
            } else if (outNode.isArray()) {
                result = this.MAPPER.treeToValue((TreeNode)outNode, List.class);
            } else if (outNode.isValueNode()) {
                result = this.MAPPER.treeToValue((TreeNode)outNode, Object.class);
            } else {
                throw new UnsupportedOperationException("TODO");
            }
            return result;
        }
        catch (Exception e) {
            throw new ScriptException(e);
        }
    }

    @Override
    public Object eval(Reader reader, ScriptContext context) throws ScriptException {
        Scanner scanner = new Scanner(reader);
        try {
            String script = scanner.useDelimiter("\\Z").next();
            Object object = this.eval(script, context);
            scanner.close();
            return object;
        }
        catch (Throwable throwable) {
            try {
                try {
                    scanner.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new ScriptException(e);
            }
        }
    }

    @Override
    public Bindings createBindings() {
        return new SimpleBindings();
    }

    @Override
    public ScriptEngineFactory getFactory() {
        return this.factory;
    }
}

