/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.backend.marshalling.v1_3.xstream;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.CannotResolveClassException;
import java.util.ArrayList;
import java.util.List;
import org.kie.dmn.api.marshalling.DMNExtensionRegister;
import org.kie.dmn.backend.marshalling.v1_3.xstream.DMNModelInstrumentedBaseConverter;
import org.kie.dmn.model.api.DMNModelInstrumentedBase;
import org.kie.dmn.model.api.dmndi.DiagramElement;
import org.kie.dmn.model.v1_3.KieDMNModelInstrumentedBase;
import org.kie.dmn.model.v1_3.dmndi.DiagramElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiagramElementExtensionConverter
extends DMNModelInstrumentedBaseConverter {
    private static final Logger LOG = LoggerFactory.getLogger(DiagramElementExtensionConverter.class);
    private List<DMNExtensionRegister> extensionRegisters = new ArrayList<DMNExtensionRegister>();

    @Override
    protected void assignAttributes(HierarchicalStreamReader reader, Object parent) {
        super.assignAttributes(reader, parent);
    }

    public DiagramElementExtensionConverter(XStream xStream, List<DMNExtensionRegister> extensionRegisters) {
        super(xStream);
        if (!extensionRegisters.isEmpty()) {
            this.extensionRegisters.addAll(extensionRegisters);
        }
    }

    @Override
    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        DMNModelInstrumentedBase obj = this.createModelObject();
        this.assignAttributes(reader, obj);
        if (this.extensionRegisters.size() == 0) {
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                String nodeName = reader.getNodeName();
                reader.moveUp();
            }
        } else {
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                String nodeName = reader.getNodeName();
                try {
                    Object object = this.readItem(reader, context, null);
                    if (object instanceof DMNModelInstrumentedBase) {
                        ((KieDMNModelInstrumentedBase)object).setParent(obj);
                        obj.addChildren((DMNModelInstrumentedBase)((KieDMNModelInstrumentedBase)object));
                    }
                    this.assignChildElement(obj, nodeName, object);
                }
                catch (CannotResolveClassException e) {
                    LOG.debug("Tried to convert the extension element child {}, but no converter is registered for this child.", (Object)nodeName);
                }
                reader.moveUp();
            }
        }
        return obj;
    }

    @Override
    protected void writeAttributes(HierarchicalStreamWriter writer, Object parent) {
        super.writeAttributes(writer, parent);
    }

    @Override
    protected void writeChildren(HierarchicalStreamWriter writer, MarshallingContext context, Object parent) {
        super.writeChildren(writer, context, parent);
        if (this.extensionRegisters.size() == 0) {
            return;
        }
        DiagramElement.Extension ee = (DiagramElement.Extension)parent;
        if (ee.getAny() != null) {
            for (Object a : ee.getAny()) {
                this.writeItem(a, context, writer);
            }
        }
    }

    public DiagramElementExtensionConverter(XStream xstream) {
        super(xstream);
    }

    @Override
    protected DMNModelInstrumentedBase createModelObject() {
        return new DiagramElement.Extension();
    }

    public boolean canConvert(Class clazz) {
        return clazz.equals(DiagramElement.Extension.class);
    }

    @Override
    public void assignChildElement(Object parent, String nodeName, Object child) {
        DiagramElement.Extension id = (DiagramElement.Extension)parent;
        id.getAny().add(child);
    }
}

