/*
 * Decompiled with CFR 0.152.
 */
package org.kie.util;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.kie.KnowledgeBaseFactoryService;
import org.kie.Service;
import org.kie.builder.KieFactory;
import org.kie.builder.KieScanner;
import org.kie.builder.KieServices;
import org.kie.concurrent.KieExecutors;
import org.kie.marshalling.KieMarshallers;
import org.kie.util.ServiceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceRegistryImpl
implements ServiceRegistry {
    private static final ServiceRegistry instance = new ServiceRegistryImpl();
    protected static final transient Logger logger = LoggerFactory.getLogger(ServiceRegistryImpl.class);
    private final Map<String, Callable<?>> registry = new HashMap();
    private final Map<String, Callable<?>> defaultServices = new HashMap();

    public static synchronized ServiceRegistry getInstance() {
        return instance;
    }

    public ServiceRegistryImpl() {
        this.init();
    }

    @Override
    public synchronized void registerLocator(Class cls, Callable cal) {
        this.registry.put(cls.getName(), cal);
    }

    @Override
    public synchronized void unregisterLocator(Class cls) {
        this.registry.remove(cls.getName());
    }

    synchronized void registerInstance(Service service, Map map) {
        String[] values;
        logger.info("regInstance : " + map);
        for (String v : values = (String[])map.get("objectClass")) {
            logger.info(v);
        }
        this.registry.put(service.getClass().getInterfaces()[0].getName(), new ReturnInstance(service));
    }

    synchronized void unregisterInstance(Service service, Map map) {
        logger.info("unregister : " + map);
        String name = service.getClass().getInterfaces()[0].getName();
        this.registry.remove(name);
        this.registry.put(name, this.defaultServices.get(name));
    }

    @Override
    public synchronized <T> T get(Class<T> cls) {
        Callable<?> cal = this.registry.get(cls.getName());
        if (cal != null) {
            try {
                return cls.cast(cal.call());
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unable to instantiate service for Class '" + (cls != null ? cls.getName() : null) + "'", e);
            }
        }
        cal = this.defaultServices.get(cls.getName());
        try {
            return cls.cast(cal.call());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to instantiate service for Class '" + (cls != null ? cls.getName() : null) + "'", e);
        }
    }

    private void init() {
        this.addDefault("org.kie.builder.KnowledgeBuilderFactoryService", "org.drools.builder.impl.KnowledgeBuilderFactoryServiceImpl");
        this.addDefault("org.kie.builder.KnowledgeContainerFactoryService", "org.drools.builder.impl.KnowledgeContainerFactoryServiceImpl");
        this.addDefault(KnowledgeBaseFactoryService.class, "org.drools.impl.KnowledgeBaseFactoryServiceImpl");
        this.addDefault("org.kie.io.ResourceFactoryService", "org.drools.io.impl.ResourceFactoryServiceImpl");
        this.addDefault("org.kie.SystemEventListenerService", "org.drools.impl.SystemEventListenerServiceImpl");
        this.addDefault(KieMarshallers.class, "org.drools.marshalling.impl.MarshallerProviderImpl");
        this.addDefault(KieExecutors.class, "org.drools.concurrent.ExecutorProviderImpl");
        this.addDefault(KieServices.class, "org.kie.builder.impl.KieServicesImpl");
        this.addDefault(KieFactory.class, "org.kie.builder.impl.KieFactoryImpl");
        this.addDefault(KieScanner.class, "org.drools.scanner.KieRepositoryScannerImpl");
    }

    @Override
    public synchronized void addDefault(Class cls, String impl) {
        this.addDefault(cls.getName(), impl);
    }

    private synchronized void addDefault(String service, String impl) {
        ReflectionInstantiator resourceRi = new ReflectionInstantiator(impl);
        this.defaultServices.put(service, resourceRi);
    }

    static class ReturnInstance<V>
    implements Callable<V> {
        private final Service service;

        public ReturnInstance(Service service) {
            this.service = service;
        }

        @Override
        public V call() throws Exception {
            return (V)this.service;
        }
    }

    static class ReflectionInstantiator<V>
    implements Callable<V> {
        private final String name;

        public ReflectionInstantiator(String name) {
            this.name = name;
        }

        @Override
        public V call() throws Exception {
            return (V)ReflectionInstantiator.newInstance(this.name);
        }

        static <T> T newInstance(String name) {
            try {
                Class<?> cls = Class.forName(name);
                return (T)cls.newInstance();
            }
            catch (Exception e2) {
                throw new IllegalArgumentException("Unable to instantiate '" + name + "'", e2);
            }
        }
    }
}

