/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.events.mongodb.codec;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import org.bson.BsonReader;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.BsonWriter;
import org.bson.Document;
import org.bson.codecs.CollectibleCodec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.kie.kogito.event.process.ProcessInstanceDataEvent;
import org.kie.kogito.events.mongodb.codec.CodecUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessInstanceDataEventCodec
implements CollectibleCodec<ProcessInstanceDataEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessInstanceDataEventCodec.class);

    public ProcessInstanceDataEvent generateIdIfAbsentFromDocument(ProcessInstanceDataEvent processInstanceDataEvent) {
        return processInstanceDataEvent;
    }

    public boolean documentHasId(ProcessInstanceDataEvent processInstanceDataEvent) {
        return processInstanceDataEvent.getId() != null;
    }

    public BsonValue getDocumentId(ProcessInstanceDataEvent processInstanceDataEvent) {
        return new BsonString(processInstanceDataEvent.getId());
    }

    public ProcessInstanceDataEvent decode(BsonReader bsonReader, DecoderContext decoderContext) {
        return null;
    }

    public void encode(BsonWriter bsonWriter, ProcessInstanceDataEvent processInstanceDataEvent, EncoderContext encoderContext) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.findAndRegisterModules();
            mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
            Document document = Document.parse((String)mapper.writeValueAsString((Object)processInstanceDataEvent));
            document.put("_id", (Object)processInstanceDataEvent.getId());
            CodecUtils.codec().encode(bsonWriter, (Object)document, encoderContext);
        }
        catch (JsonProcessingException e) {
            LOGGER.error("Could not process json event", (Throwable)e);
        }
    }

    public Class<ProcessInstanceDataEvent> getEncoderClass() {
        return ProcessInstanceDataEvent.class;
    }
}

