/*
 * Decompiled with CFR 0.152.
 */
package org.kie.efesto.runtimemanager.core.model;

import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import org.kie.efesto.common.api.identifiers.ModelLocalUriId;
import org.kie.efesto.common.api.io.IndexFile;
import org.kie.efesto.common.api.listener.EfestoListener;
import org.kie.efesto.common.api.model.GeneratedResources;
import org.kie.efesto.common.core.utils.JSONUtils;
import org.kie.efesto.runtimemanager.api.exceptions.EfestoRuntimeManagerException;
import org.kie.efesto.runtimemanager.api.model.EfestoRuntimeContext;
import org.kie.efesto.runtimemanager.api.service.KieRuntimeService;
import org.kie.efesto.runtimemanager.api.utils.SPIUtils;
import org.kie.memorycompiler.KieMemoryCompiler;

public class EfestoRuntimeContextImpl<T extends EfestoListener>
implements EfestoRuntimeContext<T> {
    private final KieMemoryCompiler.MemoryCompilerClassLoader memoryCompilerClassLoader;
    protected final Map<String, GeneratedResources> generatedResourcesMap = new HashMap<String, GeneratedResources>();

    protected EfestoRuntimeContextImpl(KieMemoryCompiler.MemoryCompilerClassLoader memoryCompilerClassLoader) {
        this.memoryCompilerClassLoader = memoryCompilerClassLoader;
        this.prepareClassLoader();
        this.populateGeneratedResourcesMap();
    }

    protected EfestoRuntimeContextImpl(KieMemoryCompiler.MemoryCompilerClassLoader memoryCompilerClassLoader, Map<String, GeneratedResources> generatedResourcesMap) {
        this.memoryCompilerClassLoader = memoryCompilerClassLoader;
        this.prepareClassLoader();
        this.generatedResourcesMap.putAll(generatedResourcesMap);
    }

    private void prepareClassLoader() {
        for (ModelLocalUriId modelLocalUriId : this.localUriIdKeySet()) {
            Map generatedClasses = this.getGeneratedClasses(modelLocalUriId);
            generatedClasses.forEach((arg_0, arg_1) -> ((KieMemoryCompiler.MemoryCompilerClassLoader)this.memoryCompilerClassLoader).addCodeIfAbsent(arg_0, arg_1));
        }
    }

    private void populateGeneratedResourcesMap() {
        Set modelTypes = SPIUtils.collectModelTypes((EfestoRuntimeContext)this);
        Map indexFileMap = IndexFile.findIndexFilesFromClassLoader((ClassLoader)this.memoryCompilerClassLoader, (Set)modelTypes);
        indexFileMap.forEach((model, indexFile) -> {
            try {
                GeneratedResources generatedResources = JSONUtils.getGeneratedResourcesObject((IndexFile)indexFile);
                this.generatedResourcesMap.put((String)model, generatedResources);
            }
            catch (Exception e) {
                throw new EfestoRuntimeManagerException("Failed to read IndexFile content : " + indexFile.getAbsolutePath(), (Throwable)e);
            }
        });
    }

    public Map<String, GeneratedResources> getGeneratedResourcesMap() {
        return this.generatedResourcesMap;
    }

    public Class<?> loadClass(String className) throws ClassNotFoundException {
        return this.memoryCompilerClassLoader.loadClass(className);
    }

    public ServiceLoader<KieRuntimeService> getKieRuntimeService() {
        return ServiceLoader.load(KieRuntimeService.class, (ClassLoader)this.memoryCompilerClassLoader);
    }
}

