/*
 * Decompiled with CFR 0.152.
 */
package org.kie.efesto.runtimemanager.core.service;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.kie.efesto.runtimemanager.api.model.EfestoInput;
import org.kie.efesto.runtimemanager.api.model.EfestoOutput;
import org.kie.efesto.runtimemanager.api.model.EfestoRuntimeContext;
import org.kie.efesto.runtimemanager.api.service.KieRuntimeService;
import org.kie.efesto.runtimemanager.api.service.RuntimeManager;
import org.kie.efesto.runtimemanager.api.utils.SPIUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuntimeManagerImpl
implements RuntimeManager {
    private static final Logger logger = LoggerFactory.getLogger((String)RuntimeManagerImpl.class.getName());

    public Collection<EfestoOutput> evaluateInput(EfestoRuntimeContext context, EfestoInput ... toEvaluate) {
        if (toEvaluate.length == 1) {
            return RuntimeManagerImpl.getOptionalOutput(context, toEvaluate[0]).map(Collections::singletonList).orElse(Collections.emptyList());
        }
        return Arrays.stream(toEvaluate).flatMap(input -> RuntimeManagerImpl.getOptionalOutput(context, input).map(Stream::of).orElse(Stream.empty())).collect(Collectors.toList());
    }

    static Optional<EfestoOutput> getOptionalOutput(EfestoRuntimeContext context, EfestoInput input) {
        Optional<KieRuntimeService> retrieved = RuntimeManagerImpl.getKieRuntimeServiceLocal(context, input);
        return retrieved.isPresent() ? retrieved.flatMap(kieRuntimeService -> kieRuntimeService.evaluateInput(input, context)) : Optional.empty();
    }

    static Optional<KieRuntimeService> getKieRuntimeServiceLocal(EfestoRuntimeContext context, EfestoInput input) {
        Optional retrieved = SPIUtils.getKieRuntimeService((EfestoInput)input, (boolean)false, (EfestoRuntimeContext)context);
        if (retrieved.isEmpty()) {
            logger.warn("Cannot find KieRuntimeService for {}, looking inside context classloader", (Object)input.getModelLocalUriId());
            retrieved = SPIUtils.getKieRuntimeServiceFromEfestoRuntimeContext((EfestoInput)input, (EfestoRuntimeContext)context);
        }
        if (retrieved.isEmpty()) {
            logger.warn("Cannot find KieRuntimeService for {}", (Object)input.getModelLocalUriId());
        }
        return retrieved;
    }
}

