/*
 * Decompiled with CFR 0.152.
 */
package org.kie.efesto.runtimemanager.core.service;

import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.kie.efesto.runtimemanager.api.model.EfestoInput;
import org.kie.efesto.runtimemanager.api.model.EfestoOutput;
import org.kie.efesto.runtimemanager.api.model.EfestoRuntimeContext;
import org.kie.efesto.runtimemanager.api.service.RuntimeManager;
import org.kie.efesto.runtimemanager.api.utils.SPIUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuntimeManagerImpl
implements RuntimeManager {
    private static final Logger logger = LoggerFactory.getLogger((String)RuntimeManagerImpl.class.getName());

    public Collection<EfestoOutput> evaluateInput(EfestoRuntimeContext context, EfestoInput ... toEvaluate) {
        return Arrays.stream(toEvaluate).flatMap(input -> this.getOptionalOutput(context, (EfestoInput)input).map(Stream::of).orElse(Stream.empty())).collect(Collectors.toList());
    }

    private Optional<EfestoOutput> getOptionalOutput(EfestoRuntimeContext context, EfestoInput input) {
        Optional retrieved = SPIUtils.getKieRuntimeService((EfestoInput)input, (boolean)false, (EfestoRuntimeContext)context);
        if (!retrieved.isPresent()) {
            logger.warn("Cannot find KieRuntimeService for {}", (Object)input.getFRI());
            return Optional.empty();
        }
        return retrieved.flatMap(kieRuntimeService -> kieRuntimeService.evaluateInput(input, context));
    }
}

