/*
 * Decompiled with CFR 0.152.
 */
package org.kie.efesto.runtimemanager.core.serialization;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import org.kie.efesto.common.api.exceptions.KieEfestoCommonException;
import org.kie.efesto.common.core.utils.JSONUtils;
import org.kie.efesto.runtimemanager.api.model.EfestoOutput;

public class EfestoOutputDeserializer
extends StdDeserializer<EfestoOutput> {
    private static final long serialVersionUID = 5014755163979962781L;

    public EfestoOutputDeserializer() {
        this(null);
    }

    public EfestoOutputDeserializer(Class<EfestoOutput> t) {
        super(t);
    }

    public EfestoOutput deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)p.getCodec().readTree(p);
        try {
            String kind = node.get("kind").asText();
            Class<?> actualClass = Class.forName(kind);
            ((ObjectNode)node).remove("kind");
            String cleanedNode = node.toString();
            return (EfestoOutput)JSONUtils.getObjectMapper().readValue(cleanedNode, actualClass);
        }
        catch (Exception e) {
            throw new KieEfestoCommonException(String.format("Failed to deserialize %s as EfestoOutput", node), (Throwable)e);
        }
    }
}

