/*
 * Decompiled with CFR 0.152.
 */
package org.kie.efesto.runtimemanager.api.utils;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import org.kie.efesto.common.api.identifiers.ModelLocalUriId;
import org.kie.efesto.common.api.model.EfestoContext;
import org.kie.efesto.common.api.model.GeneratedExecutableResource;
import org.kie.efesto.common.api.model.GeneratedRedirectResource;
import org.kie.efesto.common.api.model.GeneratedResource;
import org.kie.efesto.common.api.model.GeneratedResources;
import org.kie.efesto.common.api.utils.CollectionUtils;
import org.kie.efesto.runtimemanager.api.exceptions.KieRuntimeServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneratedResourceUtils {
    private static final Logger logger = LoggerFactory.getLogger((String)GeneratedResourceUtils.class.getName());

    private GeneratedResourceUtils() {
    }

    public static boolean isPresentExecutableOrRedirect(ModelLocalUriId modelLocalUriId, EfestoContext context) {
        return GeneratedResourceUtils.getGeneratedExecutableResource(modelLocalUriId, context.getGeneratedResourcesMap()).isPresent() || GeneratedResourceUtils.getGeneratedRedirectResource(modelLocalUriId, context.getGeneratedResourcesMap()).isPresent();
    }

    public static Optional<GeneratedExecutableResource> getGeneratedExecutableResource(ModelLocalUriId modelLocalUriId, Map<String, GeneratedResources> generatedResourcesMap) {
        if (!generatedResourcesMap.containsKey(modelLocalUriId.model())) {
            return Optional.empty();
        }
        return GeneratedResourceUtils.getGeneratedExecutableResource(modelLocalUriId, generatedResourcesMap.get(modelLocalUriId.model()));
    }

    public static Optional<GeneratedExecutableResource> getGeneratedExecutableResource(ModelLocalUriId modelLocalUriId, GeneratedResources generatedResources) {
        Collection<GeneratedExecutableResource> allExecutableResources = GeneratedResourceUtils.getAllGeneratedExecutableResources(generatedResources);
        return CollectionUtils.findAtMostOne(allExecutableResources, generatedResource -> generatedResource.getModelLocalUriId().equals((Object)modelLocalUriId), (s1, s2) -> new KieRuntimeServiceException("Found more than one Executable Resource (" + s1 + " and " + s2 + ") for " + modelLocalUriId));
    }

    public static Optional<GeneratedRedirectResource> getGeneratedRedirectResource(ModelLocalUriId modelLocalUriId, Map<String, GeneratedResources> generatedResourcesMap) {
        if (!generatedResourcesMap.containsKey(modelLocalUriId.model())) {
            return Optional.empty();
        }
        return GeneratedResourceUtils.getGeneratedRedirectResource(modelLocalUriId, generatedResourcesMap.get(modelLocalUriId.model()));
    }

    public static Optional<GeneratedRedirectResource> getGeneratedRedirectResource(ModelLocalUriId modelLocalUriId, GeneratedResources generatedResources) {
        HashSet<GeneratedRedirectResource> allExecutableResources = new HashSet<GeneratedRedirectResource>();
        for (GeneratedResource generatedResource2 : generatedResources) {
            if (!(generatedResource2 instanceof GeneratedRedirectResource)) continue;
            allExecutableResources.add((GeneratedRedirectResource)generatedResource2);
        }
        return CollectionUtils.findAtMostOne(allExecutableResources, generatedResource -> generatedResource.getModelLocalUriId().equals((Object)modelLocalUriId), (s1, s2) -> new KieRuntimeServiceException("Found more than one Redirect Resource (" + s1 + " and " + s2 + ") for " + modelLocalUriId));
    }

    public static Collection<GeneratedExecutableResource> getAllGeneratedExecutableResources(GeneratedResources generatedResources) {
        HashSet<GeneratedExecutableResource> toReturn = new HashSet<GeneratedExecutableResource>();
        try {
            logger.debug("getAllGeneratedExecutableResources {}", (Object)generatedResources);
            for (GeneratedResource generatedResource : generatedResources) {
                if (!(generatedResource instanceof GeneratedExecutableResource)) continue;
                toReturn.add((GeneratedExecutableResource)generatedResource);
            }
        }
        catch (Exception e) {
            logger.error("Failed to read GeneratedClassResource from context.", (Throwable)e);
        }
        return toReturn;
    }
}

