/*
 * Decompiled with CFR 0.152.
 */
package org.kie.efesto.compilationmanager.core.utils;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.kie.efesto.common.api.io.IndexFile;
import org.kie.efesto.common.api.model.GeneratedClassResource;
import org.kie.efesto.common.api.model.GeneratedExecutableResource;
import org.kie.efesto.common.api.model.GeneratedRedirectResource;
import org.kie.efesto.common.api.model.GeneratedResource;
import org.kie.efesto.common.api.model.GeneratedResources;
import org.kie.efesto.common.api.utils.FileUtils;
import org.kie.efesto.common.api.utils.JSONUtils;
import org.kie.efesto.compilationmanager.api.exceptions.KieCompilerServiceException;
import org.kie.efesto.compilationmanager.api.model.EfestoCallableOutput;
import org.kie.efesto.compilationmanager.api.model.EfestoCallableOutputClassesContainer;
import org.kie.efesto.compilationmanager.api.model.EfestoClassesContainer;
import org.kie.efesto.compilationmanager.api.model.EfestoCompilationContext;
import org.kie.efesto.compilationmanager.api.model.EfestoCompilationOutput;
import org.kie.efesto.compilationmanager.api.model.EfestoRedirectOutput;
import org.kie.efesto.compilationmanager.api.model.EfestoResource;
import org.kie.efesto.compilationmanager.api.service.KieCompilerService;
import org.kie.efesto.compilationmanager.api.utils.SPIUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompilationManagerUtils {
    private static final Logger logger = LoggerFactory.getLogger((String)CompilationManagerUtils.class.getName());
    private static final String DEFAULT_INDEXFILE_DIRECTORY = "./target/classes";

    private CompilationManagerUtils() {
    }

    public static Set<IndexFile> getIndexFilesWithProcessedResource(EfestoResource toProcess, EfestoCompilationContext context) {
        Optional retrieved = SPIUtils.getKieCompilerService((EfestoResource)toProcess, (boolean)false);
        if (!retrieved.isPresent()) {
            logger.warn("Cannot find KieCompilerService for {}, trying in context classloader", toProcess.getClass());
            retrieved = SPIUtils.getKieCompilerServiceFromEfestoCompilationContext((EfestoResource)toProcess, (EfestoCompilationContext)context);
        }
        if (!retrieved.isPresent()) {
            logger.warn("Cannot find KieCompilerService for {}", toProcess.getClass());
            return Collections.emptySet();
        }
        HashSet<IndexFile> toPopulate = new HashSet<IndexFile>();
        List efestoCompilationOutputList = ((KieCompilerService)retrieved.get()).processResource(toProcess, context);
        for (EfestoCompilationOutput compilationOutput : efestoCompilationOutputList) {
            if (compilationOutput instanceof EfestoCallableOutput) {
                IndexFile indexFile = CompilationManagerUtils.getIndexFile((EfestoCallableOutput)compilationOutput);
                toPopulate.add(indexFile);
                CompilationManagerUtils.populateIndexFile(indexFile, compilationOutput);
                if (!(compilationOutput instanceof EfestoCallableOutputClassesContainer)) continue;
                EfestoCallableOutputClassesContainer classesContainer = (EfestoCallableOutputClassesContainer)compilationOutput;
                context.loadClasses(classesContainer.getCompiledClassesMap());
                context.addGeneratedClasses(classesContainer.getFri(), classesContainer.getCompiledClassesMap());
                continue;
            }
            if (!(compilationOutput instanceof EfestoResource)) continue;
            toPopulate.addAll(CompilationManagerUtils.getIndexFilesWithProcessedResource((EfestoResource)compilationOutput, context));
        }
        return toPopulate;
    }

    public static Optional<IndexFile> getExistingIndexFile(String model) {
        String parentPath = System.getProperty("indexfile.directory", DEFAULT_INDEXFILE_DIRECTORY);
        IndexFile toReturn = new IndexFile(parentPath, model);
        return FileUtils.getFileFromFileNameOrFilePath((String)toReturn.getName(), (String)toReturn.getAbsolutePath()).map(IndexFile::new);
    }

    static IndexFile getIndexFile(EfestoCallableOutput compilationOutput) {
        String parentPath = System.getProperty("indexfile.directory", DEFAULT_INDEXFILE_DIRECTORY);
        IndexFile toReturn = new IndexFile(parentPath, compilationOutput.getFri().getModel());
        return CompilationManagerUtils.getExistingIndexFile(compilationOutput.getFri().getModel()).orElseGet(() -> CompilationManagerUtils.createIndexFile(toReturn));
    }

    private static IndexFile createIndexFile(IndexFile toCreate) {
        try {
            logger.debug("Writing file {} {}", (Object)toCreate.getAbsolutePath(), (Object)toCreate.getName());
            if (!toCreate.createNewFile()) {
                throw new KieCompilerServiceException("Failed to create (" + toCreate.getAbsolutePath() + ") " + toCreate.getName());
            }
        }
        catch (IOException e) {
            String errorMessage = e.getMessage() != null && !e.getMessage().isEmpty() ? e.getMessage() : e.getClass().getName();
            logger.error("Failed to create {} {} due to {}", new Object[]{toCreate.getAbsolutePath(), toCreate.getName(), errorMessage});
            throw new KieCompilerServiceException("Failed to create (" + toCreate.getAbsolutePath() + ") " + toCreate.getName(), (Throwable)e);
        }
        return toCreate;
    }

    static void populateIndexFile(IndexFile toPopulate, EfestoCompilationOutput compilationOutput) {
        try {
            GeneratedResources generatedResources = JSONUtils.getGeneratedResourcesObject((IndexFile)toPopulate);
            CompilationManagerUtils.populateGeneratedResources(generatedResources, compilationOutput);
            JSONUtils.writeGeneratedResourcesObject((GeneratedResources)generatedResources, (IndexFile)toPopulate);
        }
        catch (Exception e) {
            throw new KieCompilerServiceException((Throwable)e);
        }
    }

    static void populateGeneratedResources(GeneratedResources toPopulate, EfestoCompilationOutput compilationOutput) {
        toPopulate.add((Object)CompilationManagerUtils.getGeneratedResource(compilationOutput));
        if (compilationOutput instanceof EfestoClassesContainer) {
            toPopulate.addAll(CompilationManagerUtils.getGeneratedResources((EfestoClassesContainer)compilationOutput));
        }
    }

    static GeneratedResource getGeneratedResource(EfestoCompilationOutput compilationOutput) {
        if (compilationOutput instanceof EfestoRedirectOutput) {
            return new GeneratedRedirectResource(((EfestoRedirectOutput)compilationOutput).getFri(), ((EfestoRedirectOutput)compilationOutput).getTargetEngine());
        }
        if (compilationOutput instanceof EfestoCallableOutput) {
            return new GeneratedExecutableResource(((EfestoCallableOutput)compilationOutput).getFri(), ((EfestoCallableOutput)compilationOutput).getFullClassNames());
        }
        throw new KieCompilerServiceException("Unmanaged type " + compilationOutput.getClass().getName());
    }

    static List<GeneratedResource> getGeneratedResources(EfestoClassesContainer finalOutput) {
        return finalOutput.getCompiledClassesMap().keySet().stream().map(CompilationManagerUtils::getGeneratedClassResource).collect(Collectors.toList());
    }

    static GeneratedClassResource getGeneratedClassResource(String fullClassName) {
        return new GeneratedClassResource(fullClassName);
    }
}

