/*
 * Decompiled with CFR 0.152.
 */
package org.kie.efesto.compilationmanager.api.model;

import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import org.kie.efesto.common.api.io.IndexFile;
import org.kie.efesto.common.api.listener.EfestoListener;
import org.kie.efesto.common.api.model.GeneratedResources;
import org.kie.efesto.common.api.utils.JSONUtils;
import org.kie.efesto.compilationmanager.api.exceptions.EfestoCompilationManagerException;
import org.kie.efesto.compilationmanager.api.model.EfestoCompilationContext;
import org.kie.efesto.compilationmanager.api.service.KieCompilerService;
import org.kie.efesto.compilationmanager.api.utils.SPIUtils;
import org.kie.memorycompiler.JavaConfiguration;
import org.kie.memorycompiler.KieMemoryCompiler;
import org.kie.memorycompiler.KieMemoryCompilerException;

public class EfestoCompilationContextImpl<T extends EfestoListener>
implements EfestoCompilationContext<T> {
    protected final KieMemoryCompiler.MemoryCompilerClassLoader memoryCompilerClassLoader;
    protected final Map<String, GeneratedResources> generatedResourcesMap = new HashMap<String, GeneratedResources>();

    protected EfestoCompilationContextImpl(KieMemoryCompiler.MemoryCompilerClassLoader memoryCompilerClassLoader) {
        this.memoryCompilerClassLoader = memoryCompilerClassLoader;
        this.prepareClassLoader();
        this.populateGeneratedResourcesMap();
    }

    private void prepareClassLoader() {
        Set localUriKeySet = this.localUriIdKeySet();
        localUriKeySet.stream().map(arg_0 -> ((EfestoCompilationContextImpl)this).getGeneratedClasses(arg_0)).forEach(generatedClasses -> generatedClasses.forEach((arg_0, arg_1) -> ((KieMemoryCompiler.MemoryCompilerClassLoader)this.memoryCompilerClassLoader).addCodeIfAbsent(arg_0, arg_1)));
    }

    private void populateGeneratedResourcesMap() {
        Set<String> modelTypes = SPIUtils.collectModelTypes(this);
        Map indexFileMap = IndexFile.findIndexFilesFromClassLoader((ClassLoader)this.memoryCompilerClassLoader, modelTypes);
        indexFileMap.forEach((model, indexFile) -> {
            try {
                GeneratedResources generatedResources = JSONUtils.getGeneratedResourcesObject((IndexFile)indexFile);
                this.generatedResourcesMap.put((String)model, generatedResources);
            }
            catch (Exception e) {
                throw new EfestoCompilationManagerException("Failed to read IndexFile content : " + indexFile.getAbsolutePath(), e);
            }
        });
    }

    public Map<String, GeneratedResources> getGeneratedResourcesMap() {
        return this.generatedResourcesMap;
    }

    public void addGeneratedResources(String model, GeneratedResources generatedResources) {
        this.generatedResourcesMap.put(model, generatedResources);
    }

    @Override
    public Map<String, byte[]> compileClasses(Map<String, String> sourcesMap) {
        return KieMemoryCompiler.compileNoLoad(sourcesMap, (ClassLoader)this.memoryCompilerClassLoader, (JavaConfiguration.CompilerType)JavaConfiguration.CompilerType.NATIVE);
    }

    @Override
    public void loadClasses(Map<String, byte[]> compiledClassesMap) {
        for (Map.Entry<String, byte[]> entry : compiledClassesMap.entrySet()) {
            this.memoryCompilerClassLoader.addCode(entry.getKey(), entry.getValue());
            try {
                this.memoryCompilerClassLoader.loadClass(entry.getKey());
            }
            catch (ClassNotFoundException e) {
                throw new KieMemoryCompilerException(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public ServiceLoader<KieCompilerService> getKieCompilerServiceLoader() {
        return ServiceLoader.load(KieCompilerService.class, (ClassLoader)this.memoryCompilerClassLoader);
    }

    @Override
    public byte[] getCode(String name) {
        return this.memoryCompilerClassLoader.getCode(name);
    }

    @Override
    public Map<String, IndexFile> createIndexFiles(Path targetDirectory) {
        HashMap<String, IndexFile> indexFiles = new HashMap<String, IndexFile>();
        for (Map.Entry<String, GeneratedResources> entry : this.generatedResourcesMap.entrySet()) {
            String model = entry.getKey();
            GeneratedResources generatedResources = entry.getValue();
            IndexFile indexFile = new IndexFile(targetDirectory.toString(), model);
            try {
                if (indexFile.exists()) {
                    GeneratedResources existingGeneratedResources = JSONUtils.getGeneratedResourcesObject((IndexFile)indexFile);
                    generatedResources.addAll((Collection)existingGeneratedResources);
                }
                JSONUtils.writeGeneratedResourcesObject((GeneratedResources)generatedResources, (IndexFile)indexFile);
            }
            catch (Exception e) {
                throw new EfestoCompilationManagerException("Failed to write to IndexFile : " + indexFile.getAbsolutePath(), e);
            }
            indexFiles.put(model, indexFile);
        }
        return indexFiles;
    }
}

