/*
 * Decompiled with CFR 0.152.
 */
package org.kie.efesto.common.utils;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.PackageDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import java.io.InputStream;
import org.drools.util.FileUtils;
import org.kie.efesto.common.api.exceptions.KieEfestoCommonException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaParserUtils {
    private static final Logger logger = LoggerFactory.getLogger((String)JavaParserUtils.class.getName());
    public static final String MAIN_CLASS_NOT_FOUND = "Main class not found";

    private JavaParserUtils() {
    }

    public static CompilationUnit getCompilationUnit(String className, String packageName, String javaTemplate, String modelClassName) {
        logger.trace("getCompilationUnit {} {}", (Object)className, (Object)packageName);
        CompilationUnit templateCU = JavaParserUtils.getFromFileName(javaTemplate);
        CompilationUnit toReturn = templateCU.clone();
        if (packageName != null && !packageName.isEmpty()) {
            toReturn.setPackageDeclaration(packageName);
        }
        ClassOrInterfaceDeclaration modelTemplate = (ClassOrInterfaceDeclaration)toReturn.getClassByName(modelClassName).orElseThrow(() -> new KieEfestoCommonException("Main class not found: " + modelClassName));
        modelTemplate.setName(className);
        return toReturn;
    }

    public static String getFullClassName(CompilationUnit cu) {
        String packageName = ((PackageDeclaration)cu.getPackageDeclaration().orElseThrow(() -> new KieEfestoCommonException("Missing package declaration for " + cu))).getName().asString();
        String className = cu.getType(0).getName().asString();
        return packageName + "." + className;
    }

    private static CompilationUnit getFromFileName(String fileName) {
        InputStream resource = (InputStream)FileUtils.getInputStreamFromFileNameAndClassLoader((String)fileName, (ClassLoader)JavaParserUtils.class.getClassLoader()).orElseThrow(() -> new KieEfestoCommonException(String.format("Failed to find InputStream for %s", fileName)));
        try {
            return StaticJavaParser.parse((InputStream)resource);
        }
        catch (Exception e) {
            throw new KieEfestoCommonException(String.format("Failed to parse %s due to %s", fileName, e.getMessage()), (Throwable)e);
        }
    }
}

