/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.examples.storage.user;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jboss.logging.Logger;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.component.ComponentModel;
import org.keycloak.examples.storage.user.ExampleUserStorageProvider;
import org.keycloak.examples.storage.user.UserEntity;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.storage.StorageId;
import org.keycloak.storage.adapter.AbstractUserAdapterFederatedStorage;

public class UserAdapter
extends AbstractUserAdapterFederatedStorage {
    private static final Logger logger = Logger.getLogger(ExampleUserStorageProvider.class);
    protected UserEntity entity;
    protected String keycloakId;

    public UserAdapter(KeycloakSession session, RealmModel realm, ComponentModel model, UserEntity entity) {
        super(session, realm, model);
        this.entity = entity;
        this.keycloakId = StorageId.keycloakId((ComponentModel)model, (String)entity.getId());
    }

    public String getUsername() {
        return this.entity.getUsername();
    }

    public void setUsername(String username) {
        this.entity.setUsername(username);
    }

    public void setEmail(String email) {
        this.entity.setEmail(email);
    }

    public String getEmail() {
        return this.entity.getEmail();
    }

    public String getId() {
        return this.keycloakId;
    }

    public void updateCredential(UserCredentialModel cred) {
        if (cred.getType().equals("password")) {
            this.entity.setPassword(cred.getValue());
        } else {
            super.updateCredential(cred);
        }
    }

    public void setSingleAttribute(String name, String value) {
        if (name.equals("phone")) {
            this.entity.setPhone(value);
        } else if (!name.equals("password")) {
            super.setSingleAttribute(name, value);
        }
    }

    public void removeAttribute(String name) {
        if (name.equals("phone")) {
            this.entity.setPhone(null);
        } else if (!name.equals("password")) {
            super.removeAttribute(name);
        }
    }

    public void setAttribute(String name, List<String> values) {
        if (name.equals("phone")) {
            this.entity.setPhone(values.get(0));
        } else if (!name.equals("password")) {
            super.setAttribute(name, values);
        }
    }

    public String getFirstAttribute(String name) {
        if (name.equals("phone")) {
            return this.entity.getPhone();
        }
        if (name.equals("password")) {
            return this.entity.getPassword();
        }
        return super.getFirstAttribute(name);
    }

    public Map<String, List<String>> getAttributes() {
        Map attrs = super.getAttributes();
        MultivaluedHashMap all = new MultivaluedHashMap();
        all.putAll(attrs);
        all.add((Object)"phone", (Object)this.entity.getPhone());
        all.add((Object)"password", (Object)this.entity.getPassword());
        return all;
    }

    public List<String> getAttribute(String name) {
        if (name.equals("phone")) {
            LinkedList<String> phone = new LinkedList<String>();
            phone.add(this.entity.getPhone());
            return phone;
        }
        return super.getAttribute(name);
    }
}

