/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.examples.storage.user;

import java.util.HashMap;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.spi.PersistenceUnitTransactionType;
import org.hibernate.boot.registry.classloading.internal.ClassLoaderServiceImpl;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.jpa.boot.internal.ParsedPersistenceXmlDescriptor;
import org.hibernate.jpa.boot.internal.PersistenceXmlParser;
import org.hibernate.jpa.boot.spi.Bootstrap;
import org.hibernate.jpa.boot.spi.PersistenceUnitDescriptor;
import org.keycloak.Config;
import org.keycloak.component.ComponentModel;
import org.keycloak.connections.jpa.JpaKeycloakTransaction;
import org.keycloak.examples.storage.user.ExampleUserStorageProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.KeycloakTransaction;
import org.keycloak.storage.UserStorageProviderFactory;

public class ExampleUserStorageProviderFactory
implements UserStorageProviderFactory<ExampleUserStorageProvider> {
    EntityManagerFactory emf = null;

    public ExampleUserStorageProvider create(KeycloakSession session, ComponentModel model) {
        EntityManager em = this.emf.createEntityManager();
        session.getTransactionManager().enlist((KeycloakTransaction)new JpaKeycloakTransaction(em));
        return new ExampleUserStorageProvider(em, model, session);
    }

    public String getId() {
        return "example-user-storage";
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
        this.emf = ExampleUserStorageProviderFactory.createEntityManagerFactory("user-storage-jpa-example");
    }

    public static EntityManagerFactory createEntityManagerFactory(String unitName) {
        PersistenceXmlParser parser = new PersistenceXmlParser((ClassLoaderService)new ClassLoaderServiceImpl(ExampleUserStorageProviderFactory.class.getClassLoader()), PersistenceUnitTransactionType.RESOURCE_LOCAL);
        List persistenceUnits = parser.doResolve(new HashMap());
        for (ParsedPersistenceXmlDescriptor persistenceUnit : persistenceUnits) {
            if (!persistenceUnit.getName().equals(unitName)) continue;
            return Bootstrap.getEntityManagerFactoryBuilder((PersistenceUnitDescriptor)persistenceUnit, new HashMap(), (ClassLoader)ExampleUserStorageProviderFactory.class.getClassLoader()).build();
        }
        throw new RuntimeException("Persistence unit '" + unitName + "' not found");
    }

    public void close() {
        this.emf.close();
    }
}

