/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.examples.storage.user;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import org.jboss.logging.Logger;
import org.keycloak.component.ComponentModel;
import org.keycloak.examples.storage.user.UserAdapter;
import org.keycloak.examples.storage.user.UserEntity;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.storage.StorageId;
import org.keycloak.storage.UserStorageProvider;
import org.keycloak.storage.user.UserCredentialValidatorProvider;
import org.keycloak.storage.user.UserLookupProvider;
import org.keycloak.storage.user.UserQueryProvider;
import org.keycloak.storage.user.UserRegistrationProvider;

public class ExampleUserStorageProvider
implements UserStorageProvider,
UserLookupProvider,
UserRegistrationProvider,
UserCredentialValidatorProvider,
UserQueryProvider {
    private static final Logger logger = Logger.getLogger(ExampleUserStorageProvider.class);
    protected EntityManager em;
    protected ComponentModel model;
    protected KeycloakSession session;

    public ExampleUserStorageProvider(EntityManager em, ComponentModel model, KeycloakSession session) {
        this.em = em;
        this.model = model;
        this.session = session;
    }

    public void preRemove(RealmModel realm) {
    }

    public void preRemove(RealmModel realm, GroupModel group) {
    }

    public void preRemove(RealmModel realm, RoleModel role) {
    }

    public void close() {
        this.em.close();
    }

    public UserModel getUserById(String id, RealmModel realm) {
        logger.info((Object)("getUserById: " + id));
        String persistenceId = StorageId.externalId((String)id);
        UserEntity entity = (UserEntity)this.em.find(UserEntity.class, (Object)persistenceId);
        if (entity == null) {
            logger.info((Object)("could not find user by id: " + id));
            return null;
        }
        return new UserAdapter(this.session, realm, this.model, entity);
    }

    public UserModel getUserByUsername(String username, RealmModel realm) {
        logger.info((Object)("getUserByUsername: " + username));
        TypedQuery query = this.em.createNamedQuery("getUserByUsername", UserEntity.class);
        query.setParameter("username", (Object)username);
        List result = query.getResultList();
        if (result.isEmpty()) {
            logger.info((Object)("could not find username: " + username));
            return null;
        }
        return new UserAdapter(this.session, realm, this.model, (UserEntity)result.get(0));
    }

    public UserModel getUserByEmail(String email, RealmModel realm) {
        TypedQuery query = this.em.createNamedQuery("getUserByEmail", UserEntity.class);
        query.setParameter("email", (Object)email);
        List result = query.getResultList();
        if (result.isEmpty()) {
            return null;
        }
        return new UserAdapter(this.session, realm, this.model, (UserEntity)result.get(0));
    }

    public UserModel addUser(RealmModel realm, String username) {
        UserEntity entity = new UserEntity();
        entity.setId(KeycloakModelUtils.generateId());
        entity.setUsername(username);
        this.em.persist((Object)entity);
        logger.info((Object)("added user: " + username));
        return new UserAdapter(this.session, realm, this.model, entity);
    }

    public boolean removeUser(RealmModel realm, UserModel user) {
        String persistenceId = StorageId.externalId((String)user.getId());
        UserEntity entity = (UserEntity)this.em.find(UserEntity.class, (Object)persistenceId);
        if (entity == null) {
            return false;
        }
        this.em.remove((Object)entity);
        return true;
    }

    public void grantToAllUsers(RealmModel realm, RoleModel role) {
    }

    public boolean validCredentials(KeycloakSession session, RealmModel realm, UserModel user, List<UserCredentialModel> input) {
        for (UserCredentialModel cred : input) {
            if (!"password".equals(cred.getType())) {
                return false;
            }
            if (cred.getValue().equals(user.getFirstAttribute("password"))) continue;
            return false;
        }
        return true;
    }

    public int getUsersCount(RealmModel realm) {
        Object count = this.em.createNamedQuery("getUserCount").getSingleResult();
        return ((Number)count).intValue();
    }

    public List<UserModel> getUsers(RealmModel realm) {
        return this.getUsers(realm, -1, -1);
    }

    public List<UserModel> getUsers(RealmModel realm, int firstResult, int maxResults) {
        TypedQuery query = this.em.createNamedQuery("getAllUsers", UserEntity.class);
        if (firstResult != -1) {
            query.setFirstResult(firstResult);
        }
        if (maxResults != -1) {
            query.setMaxResults(maxResults);
        }
        List results = query.getResultList();
        LinkedList<UserModel> users = new LinkedList<UserModel>();
        for (UserEntity entity : results) {
            users.add((UserModel)new UserAdapter(this.session, realm, this.model, entity));
        }
        return users;
    }

    public List<UserModel> searchForUser(String search, RealmModel realm) {
        return this.searchForUser(search, realm, -1, -1);
    }

    public List<UserModel> searchForUser(String search, RealmModel realm, int firstResult, int maxResults) {
        TypedQuery query = this.em.createNamedQuery("searchForUser", UserEntity.class);
        query.setParameter("search", (Object)("%" + search.toLowerCase() + "%"));
        if (firstResult != -1) {
            query.setFirstResult(firstResult);
        }
        if (maxResults != -1) {
            query.setMaxResults(maxResults);
        }
        List results = query.getResultList();
        LinkedList<UserModel> users = new LinkedList<UserModel>();
        for (UserEntity entity : results) {
            users.add((UserModel)new UserAdapter(this.session, realm, this.model, entity));
        }
        return users;
    }

    public List<UserModel> searchForUser(Map<String, String> params, RealmModel realm) {
        return Collections.EMPTY_LIST;
    }

    public List<UserModel> searchForUser(Map<String, String> params, RealmModel realm, int firstResult, int maxResults) {
        return Collections.EMPTY_LIST;
    }

    public List<UserModel> getGroupMembers(RealmModel realm, GroupModel group, int firstResult, int maxResults) {
        return Collections.EMPTY_LIST;
    }

    public List<UserModel> getGroupMembers(RealmModel realm, GroupModel group) {
        return Collections.EMPTY_LIST;
    }

    public List<UserModel> searchForUserByUserAttribute(String attrName, String attrValue, RealmModel realm) {
        return Collections.EMPTY_LIST;
    }
}

