/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util;

import com.google.common.base.Function;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.arquillian.graphene.Graphene;
import org.jboss.arquillian.graphene.wait.ElementBuilder;
import org.openqa.selenium.By;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

public final class WaitUtils {
    protected static final org.jboss.logging.Logger log = org.jboss.logging.Logger.getLogger(WaitUtils.class);
    public static final String PAGELOAD_TIMEOUT_PROP = "pageload.timeout";
    public static final Integer PAGELOAD_TIMEOUT_MILLIS = Integer.parseInt(System.getProperty("pageload.timeout", "10000"));
    public static final int IMPLICIT_ELEMENT_WAIT_MILLIS = 750;

    public static ElementBuilder<Void> waitUntilElement(By by) {
        return Graphene.waitGui().until().element(by);
    }

    public static ElementBuilder<Void> waitUntilElement(WebElement element) {
        return Graphene.waitGui().until().element(element);
    }

    public static ElementBuilder<Void> waitUntilElement(WebElement element, String failMessage) {
        return Graphene.waitGui().until(failMessage).element(element);
    }

    public static void waitUntilElementIsNotPresent(WebDriver driver, By locator) {
        WaitUtils.waitUntilElementIsNotPresent(driver, driver.findElement(locator));
    }

    public static void waitUntilElementIsNotPresent(WebDriver driver, WebElement element) {
        new WebDriverWait(driver, 750L).until((Function)ExpectedConditions.invisibilityOfAllElements(Collections.singletonList(element)));
    }

    public static void pause(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(WaitUtils.class.getName()).log(Level.SEVERE, null, ex);
            Thread.currentThread().interrupt();
        }
    }

    public static void waitForPageToLoad(WebDriver driver) {
        WebDriverWait wait = new WebDriverWait(driver, (long)(PAGELOAD_TIMEOUT_MILLIS / 1000));
        try {
            wait.until((Function)ExpectedConditions.not((ExpectedCondition)ExpectedConditions.urlContains((String)"redirect_fragment")));
            wait.until((Function)ExpectedConditions.javaScriptThrowsNoExceptions((String)"if (document.readyState !== 'complete' || (typeof angular !== 'undefined' && angular.element(document.body).injector().get('$http').pendingRequests.length !== 0)) {throw \"Not ready\";}"));
        }
        catch (TimeoutException e) {
            log.warn((Object)"waitForPageToLoad time exceeded!");
        }
    }

    public static void waitForModalFadeIn(WebDriver driver) {
        WaitUtils.pause(500L);
    }

    public static void waitForModalFadeOut(WebDriver driver) {
        WaitUtils.waitUntilElementIsNotPresent(driver, By.className((String)"modal-backdrop"));
    }
}

