/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.security.PublicKey;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.junit.Assert;
import org.keycloak.RSATokenVerifier;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.common.VerificationException;
import org.keycloak.common.util.PemUtils;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.jose.jws.crypto.RSAProvider;
import org.keycloak.protocol.oidc.OIDCLoginProtocolService;
import org.keycloak.protocol.oidc.representations.JSONWebKeySet;
import org.keycloak.protocol.oidc.utils.OIDCResponseType;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.IDToken;
import org.keycloak.representations.RefreshToken;
import org.keycloak.testsuite.arquillian.AuthServerTestEnricher;
import org.keycloak.util.BasicAuthHelper;
import org.keycloak.util.JsonSerialization;
import org.keycloak.util.TokenUtil;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;

public class OAuthClient {
    public static final String SERVER_ROOT = AuthServerTestEnricher.getAuthServerContextRoot();
    public static final String AUTH_SERVER_ROOT = SERVER_ROOT + "/auth";
    public static final String APP_ROOT = AUTH_SERVER_ROOT + "/realms/master/app";
    private Keycloak adminClient;
    private WebDriver driver;
    private String baseUrl = AUTH_SERVER_ROOT;
    private String realm;
    private String clientId;
    private String redirectUri;
    private String state;
    private String scope;
    private String uiLocales;
    private String clientSessionState;
    private String clientSessionHost;
    private String maxAge;
    private String responseType = "code";
    private String responseMode;
    private Map<String, PublicKey> publicKeys = new HashMap<String, PublicKey>();

    public void init(Keycloak adminClient, WebDriver driver) {
        this.adminClient = adminClient;
        this.driver = driver;
        this.baseUrl = AUTH_SERVER_ROOT;
        this.realm = "test";
        this.clientId = "test-app";
        this.redirectUri = APP_ROOT + "/auth";
        this.state = "mystate";
        this.scope = null;
        this.uiLocales = null;
        this.clientSessionState = null;
        this.clientSessionHost = null;
        this.maxAge = null;
    }

    public AuthorizationEndpointResponse doLogin(String username, String password) {
        this.openLoginForm();
        String src = this.driver.getPageSource();
        try {
            this.driver.findElement(By.id((String)"username")).sendKeys(new CharSequence[]{username});
            this.driver.findElement(By.id((String)"password")).sendKeys(new CharSequence[]{password});
            this.driver.findElement(By.name((String)"login")).click();
        }
        catch (Throwable t) {
            System.err.println(src);
            throw t;
        }
        return new AuthorizationEndpointResponse(this);
    }

    public void doLoginGrant(String username, String password) {
        this.openLoginForm();
        String src = this.driver.getPageSource();
        try {
            this.driver.findElement(By.id((String)"username")).sendKeys(new CharSequence[]{username});
            this.driver.findElement(By.id((String)"password")).sendKeys(new CharSequence[]{password});
            this.driver.findElement(By.name((String)"login")).click();
        }
        catch (Throwable t) {
            System.err.println(src);
            throw t;
        }
    }

    public AccessTokenResponse doAccessTokenRequest(String code, String password) {
        DefaultHttpClient client = new DefaultHttpClient();
        try {
            HttpPost post = new HttpPost(this.getAccessTokenUrl());
            LinkedList<BasicNameValuePair> parameters = new LinkedList<BasicNameValuePair>();
            parameters.add(new BasicNameValuePair("grant_type", "authorization_code"));
            if (code != null) {
                parameters.add(new BasicNameValuePair("code", code));
            }
            if (this.redirectUri != null) {
                parameters.add(new BasicNameValuePair("redirect_uri", this.redirectUri));
            }
            if (this.clientId != null && password != null) {
                String authorization = BasicAuthHelper.createHeader((String)this.clientId, (String)password);
                post.setHeader("Authorization", authorization);
            } else if (this.clientId != null) {
                parameters.add(new BasicNameValuePair("client_id", this.clientId));
            }
            if (this.clientSessionState != null) {
                parameters.add(new BasicNameValuePair("client_session_state", this.clientSessionState));
            }
            if (this.clientSessionHost != null) {
                parameters.add(new BasicNameValuePair("client_session_host", this.clientSessionHost));
            }
            UrlEncodedFormEntity formEntity = null;
            try {
                formEntity = new UrlEncodedFormEntity(parameters, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            post.setEntity((HttpEntity)formEntity);
            try {
                AccessTokenResponse e = new AccessTokenResponse((HttpResponse)client.execute((HttpUriRequest)post));
                return e;
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to retrieve access token", e);
            }
        }
        finally {
            this.closeClient((CloseableHttpClient)client);
        }
    }

    public String introspectAccessTokenWithClientCredential(String clientId, String clientSecret, String tokenToIntrospect) {
        return this.introspectTokenWithClientCredential(clientId, clientSecret, "access_token", tokenToIntrospect);
    }

    public String introspectRefreshTokenWithClientCredential(String clientId, String clientSecret, String tokenToIntrospect) {
        return this.introspectTokenWithClientCredential(clientId, clientSecret, "refresh_token", tokenToIntrospect);
    }

    public String introspectTokenWithClientCredential(String clientId, String clientSecret, String tokenType, String tokenToIntrospect) {
        DefaultHttpClient client = new DefaultHttpClient();
        try {
            UrlEncodedFormEntity formEntity;
            HttpPost post = new HttpPost(this.getTokenIntrospectionUrl());
            String authorization = BasicAuthHelper.createHeader((String)clientId, (String)clientSecret);
            post.setHeader("Authorization", authorization);
            LinkedList<BasicNameValuePair> parameters = new LinkedList<BasicNameValuePair>();
            parameters.add(new BasicNameValuePair("token", tokenToIntrospect));
            parameters.add(new BasicNameValuePair("token_type_hint", tokenType));
            try {
                formEntity = new UrlEncodedFormEntity(parameters, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            post.setEntity((HttpEntity)formEntity);
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                client.execute((HttpUriRequest)post).getEntity().writeTo((OutputStream)out);
                String string = new String(out.toByteArray());
                return string;
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to retrieve access token", e);
            }
        }
        finally {
            this.closeClient((CloseableHttpClient)client);
        }
    }

    public AccessTokenResponse doGrantAccessTokenRequest(String clientSecret, String username, String password) throws Exception {
        return this.doGrantAccessTokenRequest(this.realm, username, password, null, this.clientId, clientSecret);
    }

    public AccessTokenResponse doGrantAccessTokenRequest(String clientSecret, String username, String password, String otp) throws Exception {
        return this.doGrantAccessTokenRequest(this.realm, username, password, otp, this.clientId, clientSecret);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccessTokenResponse doGrantAccessTokenRequest(String realm, String username, String password, String totp, String clientId, String clientSecret) throws Exception {
        DefaultHttpClient client = new DefaultHttpClient();
        try {
            UrlEncodedFormEntity formEntity;
            HttpPost post = new HttpPost(this.getResourceOwnerPasswordCredentialGrantUrl(realm));
            LinkedList<BasicNameValuePair> parameters = new LinkedList<BasicNameValuePair>();
            parameters.add(new BasicNameValuePair("grant_type", "password"));
            parameters.add(new BasicNameValuePair("username", username));
            parameters.add(new BasicNameValuePair("password", password));
            if (totp != null) {
                parameters.add(new BasicNameValuePair("totp", totp));
            }
            if (clientSecret != null) {
                String authorization = BasicAuthHelper.createHeader((String)clientId, (String)clientSecret);
                post.setHeader("Authorization", authorization);
            } else {
                parameters.add(new BasicNameValuePair("client_id", clientId));
            }
            if (this.clientSessionState != null) {
                parameters.add(new BasicNameValuePair("client_session_state", this.clientSessionState));
            }
            if (this.clientSessionHost != null) {
                parameters.add(new BasicNameValuePair("client_session_host", this.clientSessionHost));
            }
            if (this.scope != null) {
                parameters.add(new BasicNameValuePair("scope", this.scope));
            }
            try {
                formEntity = new UrlEncodedFormEntity(parameters, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            post.setEntity((HttpEntity)formEntity);
            AccessTokenResponse accessTokenResponse = new AccessTokenResponse((HttpResponse)client.execute((HttpUriRequest)post));
            return accessTokenResponse;
        }
        finally {
            this.closeClient((CloseableHttpClient)client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONWebKeySet doCertsRequest(String realm) throws Exception {
        DefaultHttpClient client = new DefaultHttpClient();
        try {
            HttpGet get = new HttpGet(this.getCertsUrl(realm));
            CloseableHttpResponse response = client.execute((HttpUriRequest)get);
            JSONWebKeySet jSONWebKeySet = (JSONWebKeySet)JsonSerialization.readValue((InputStream)response.getEntity().getContent(), JSONWebKeySet.class);
            return jSONWebKeySet;
        }
        finally {
            this.closeClient((CloseableHttpClient)client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccessTokenResponse doClientCredentialsGrantAccessTokenRequest(String clientSecret) throws Exception {
        DefaultHttpClient client = new DefaultHttpClient();
        try {
            UrlEncodedFormEntity formEntity;
            HttpPost post = new HttpPost(this.getServiceAccountUrl());
            String authorization = BasicAuthHelper.createHeader((String)this.clientId, (String)clientSecret);
            post.setHeader("Authorization", authorization);
            LinkedList<BasicNameValuePair> parameters = new LinkedList<BasicNameValuePair>();
            parameters.add(new BasicNameValuePair("grant_type", "client_credentials"));
            if (this.scope != null) {
                parameters.add(new BasicNameValuePair("scope", this.scope));
            }
            try {
                formEntity = new UrlEncodedFormEntity(parameters, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            post.setEntity((HttpEntity)formEntity);
            AccessTokenResponse accessTokenResponse = new AccessTokenResponse((HttpResponse)client.execute((HttpUriRequest)post));
            return accessTokenResponse;
        }
        finally {
            this.closeClient((CloseableHttpClient)client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResponse doLogout(String refreshToken, String clientSecret) throws IOException {
        DefaultHttpClient client = new DefaultHttpClient();
        try {
            UrlEncodedFormEntity formEntity;
            HttpPost post = new HttpPost(this.getLogoutUrl(null, null));
            LinkedList<BasicNameValuePair> parameters = new LinkedList<BasicNameValuePair>();
            if (refreshToken != null) {
                parameters.add(new BasicNameValuePair("refresh_token", refreshToken));
            }
            if (this.clientId != null && clientSecret != null) {
                String authorization = BasicAuthHelper.createHeader((String)this.clientId, (String)clientSecret);
                post.setHeader("Authorization", authorization);
            } else if (this.clientId != null) {
                parameters.add(new BasicNameValuePair("client_id", this.clientId));
            }
            try {
                formEntity = new UrlEncodedFormEntity(parameters, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            post.setEntity((HttpEntity)formEntity);
            CloseableHttpResponse closeableHttpResponse = client.execute((HttpUriRequest)post);
            return closeableHttpResponse;
        }
        finally {
            this.closeClient((CloseableHttpClient)client);
        }
    }

    public AccessTokenResponse doRefreshTokenRequest(String refreshToken, String password) {
        DefaultHttpClient client = new DefaultHttpClient();
        try {
            UrlEncodedFormEntity formEntity;
            HttpPost post = new HttpPost(this.getRefreshTokenUrl());
            LinkedList<BasicNameValuePair> parameters = new LinkedList<BasicNameValuePair>();
            parameters.add(new BasicNameValuePair("grant_type", "refresh_token"));
            if (refreshToken != null) {
                parameters.add(new BasicNameValuePair("refresh_token", refreshToken));
            }
            if (this.clientId != null && password != null) {
                String authorization = BasicAuthHelper.createHeader((String)this.clientId, (String)password);
                post.setHeader("Authorization", authorization);
            } else if (this.clientId != null) {
                parameters.add(new BasicNameValuePair("client_id", this.clientId));
            }
            if (this.clientSessionState != null) {
                parameters.add(new BasicNameValuePair("client_session_state", this.clientSessionState));
            }
            if (this.clientSessionHost != null) {
                parameters.add(new BasicNameValuePair("client_session_host", this.clientSessionHost));
            }
            try {
                formEntity = new UrlEncodedFormEntity(parameters, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            post.setEntity((HttpEntity)formEntity);
            try {
                AccessTokenResponse e = new AccessTokenResponse((HttpResponse)client.execute((HttpUriRequest)post));
                return e;
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to retrieve access token", e);
            }
        }
        finally {
            this.closeClient((CloseableHttpClient)client);
        }
    }

    public void closeClient(CloseableHttpClient client) {
        try {
            client.close();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public AccessToken verifyToken(String token) {
        try {
            return RSATokenVerifier.verifyToken((String)token, (PublicKey)this.getRealmPublicKey(this.realm), (String)(this.baseUrl + "/realms/" + this.realm));
        }
        catch (VerificationException e) {
            throw new RuntimeException("Failed to verify token", e);
        }
    }

    public IDToken verifyIDToken(String token) {
        try {
            AccessToken idToken = RSATokenVerifier.verifyToken((String)token, (PublicKey)this.getRealmPublicKey(this.realm), (String)(this.baseUrl + "/realms/" + this.realm), (boolean)true, (boolean)false);
            Assert.assertEquals((Object)"ID", (Object)idToken.getType());
            return idToken;
        }
        catch (VerificationException e) {
            throw new RuntimeException("Failed to verify token", e);
        }
    }

    public RefreshToken verifyRefreshToken(String refreshToken) {
        try {
            JWSInput jws = new JWSInput(refreshToken);
            if (!RSAProvider.verify((JWSInput)jws, (PublicKey)this.getRealmPublicKey(this.realm))) {
                throw new RuntimeException("Invalid refresh token");
            }
            return (RefreshToken)jws.readJsonContent(RefreshToken.class);
        }
        catch (Exception e) {
            throw new RuntimeException("Invalid refresh token", e);
        }
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getCurrentRequest() {
        int index = this.driver.getCurrentUrl().indexOf(63);
        if (index == -1) {
            index = this.driver.getCurrentUrl().indexOf(35);
        }
        return this.driver.getCurrentUrl().substring(0, index);
    }

    public URI getCurrentUri() {
        try {
            return new URI(this.driver.getCurrentUrl());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public Map<String, String> getCurrentQuery() {
        HashMap<String, String> m = new HashMap<String, String>();
        List pairs = URLEncodedUtils.parse((URI)this.getCurrentUri(), (String)"UTF-8");
        for (NameValuePair p : pairs) {
            m.put(p.getName(), p.getValue());
        }
        return m;
    }

    public Map<String, String> getCurrentFragment() {
        HashMap<String, String> m = new HashMap<String, String>();
        String fragment = this.getCurrentUri().getRawFragment();
        List pairs = fragment == null || fragment.isEmpty() ? Collections.emptyList() : URLEncodedUtils.parse((String)fragment, (Charset)Charset.forName("UTF-8"));
        for (NameValuePair p : pairs) {
            m.put(p.getName(), p.getValue());
        }
        return m;
    }

    public void openLoginForm() {
        this.driver.navigate().to(this.getLoginFormUrl());
    }

    public void openLogout() {
        UriBuilder b = OIDCLoginProtocolService.logoutUrl((UriBuilder)UriBuilder.fromUri((String)this.baseUrl));
        if (this.redirectUri != null) {
            b.queryParam("redirect_uri", new Object[]{this.redirectUri});
        }
        this.driver.navigate().to(b.build(new Object[]{this.realm}).toString());
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public String getLoginFormUrl() {
        UriBuilder b = OIDCLoginProtocolService.authUrl((UriBuilder)UriBuilder.fromUri((String)AUTH_SERVER_ROOT));
        if (this.responseType != null) {
            b.queryParam("response_type", new Object[]{this.responseType});
        }
        if (this.responseMode != null) {
            b.queryParam("response_mode", new Object[]{this.responseMode});
        }
        if (this.clientId != null) {
            b.queryParam("client_id", new Object[]{this.clientId});
        }
        if (this.redirectUri != null) {
            b.queryParam("redirect_uri", new Object[]{this.redirectUri});
        }
        if (this.state != null) {
            b.queryParam("state", new Object[]{this.state});
        }
        if (this.uiLocales != null) {
            b.queryParam("ui_locales", new Object[]{this.uiLocales});
        }
        String scopeParam = TokenUtil.attachOIDCScope((String)this.scope);
        b.queryParam("scope", new Object[]{scopeParam});
        if (this.maxAge != null) {
            b.queryParam("max_age", new Object[]{this.maxAge});
        }
        return b.build(new Object[]{this.realm}).toString();
    }

    public String getAccessTokenUrl() {
        UriBuilder b = OIDCLoginProtocolService.tokenUrl((UriBuilder)UriBuilder.fromUri((String)this.baseUrl));
        return b.build(new Object[]{this.realm}).toString();
    }

    public String getTokenIntrospectionUrl() {
        UriBuilder b = OIDCLoginProtocolService.tokenIntrospectionUrl((UriBuilder)UriBuilder.fromUri((String)this.baseUrl));
        return b.build(new Object[]{this.realm}).toString();
    }

    public String getLogoutUrl(String redirectUri, String sessionState) {
        UriBuilder b = OIDCLoginProtocolService.logoutUrl((UriBuilder)UriBuilder.fromUri((String)this.baseUrl));
        if (redirectUri != null) {
            b.queryParam("redirect_uri", new Object[]{redirectUri});
        }
        if (sessionState != null) {
            b.queryParam("session_state", new Object[]{sessionState});
        }
        return b.build(new Object[]{this.realm}).toString();
    }

    public String getResourceOwnerPasswordCredentialGrantUrl() {
        UriBuilder b = OIDCLoginProtocolService.tokenUrl((UriBuilder)UriBuilder.fromUri((String)this.baseUrl));
        return b.build(new Object[]{this.realm}).toString();
    }

    public String getResourceOwnerPasswordCredentialGrantUrl(String realm) {
        UriBuilder b = OIDCLoginProtocolService.tokenUrl((UriBuilder)UriBuilder.fromUri((String)this.baseUrl));
        return b.build(new Object[]{realm}).toString();
    }

    public String getCertsUrl(String realm) {
        UriBuilder b = OIDCLoginProtocolService.certsUrl((UriBuilder)UriBuilder.fromUri((String)this.baseUrl));
        return b.build(new Object[]{realm}).toString();
    }

    public String getServiceAccountUrl() {
        return this.getResourceOwnerPasswordCredentialGrantUrl();
    }

    public String getRefreshTokenUrl() {
        UriBuilder b = OIDCLoginProtocolService.tokenUrl((UriBuilder)UriBuilder.fromUri((String)this.baseUrl));
        return b.build(new Object[]{this.realm}).toString();
    }

    public OAuthClient realm(String realm) {
        this.realm = realm;
        return this;
    }

    public OAuthClient clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    public OAuthClient redirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
        return this;
    }

    public OAuthClient state(String state) {
        this.state = state;
        return this;
    }

    public OAuthClient scope(String scope) {
        this.scope = scope;
        return this;
    }

    public OAuthClient uiLocales(String uiLocales) {
        this.uiLocales = uiLocales;
        return this;
    }

    public OAuthClient clientSessionState(String client_session_state) {
        this.clientSessionState = client_session_state;
        return this;
    }

    public OAuthClient clientSessionHost(String client_session_host) {
        this.clientSessionHost = client_session_host;
        return this;
    }

    public OAuthClient maxAge(String maxAge) {
        this.maxAge = maxAge;
        return this;
    }

    public OAuthClient responseType(String responseType) {
        this.responseType = responseType;
        return this;
    }

    public OAuthClient responseMode(String responseMode) {
        this.responseMode = responseMode;
        return this;
    }

    public String getRealm() {
        return this.realm;
    }

    public PublicKey getRealmPublicKey(String realm) {
        if (!this.publicKeys.containsKey(realm)) {
            String publicKeyPem = this.adminClient.realms().realm(realm).toRepresentation().getPublicKey();
            PublicKey publicKey = null;
            try {
                publicKey = PemUtils.decodePublicKey((String)publicKeyPem);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.publicKeys.put(realm, publicKey);
        }
        return this.publicKeys.get(realm);
    }

    public static class AccessTokenResponse {
        private int statusCode;
        private String idToken;
        private String accessToken;
        private String tokenType;
        private int expiresIn;
        private int refreshExpiresIn;
        private String refreshToken;
        private String error;
        private String errorDescription;

        public AccessTokenResponse(HttpResponse response) throws Exception {
            this.statusCode = response.getStatusLine().getStatusCode();
            if (!"application/json".equals(response.getHeaders("Content-Type")[0].getValue())) {
                Assert.fail((String)"Invalid content type");
            }
            String s = IOUtils.toString((InputStream)response.getEntity().getContent());
            Map responseJson = (Map)JsonSerialization.readValue((String)s, Map.class);
            if (this.statusCode == 200) {
                this.idToken = (String)responseJson.get("id_token");
                this.accessToken = (String)responseJson.get("access_token");
                this.tokenType = (String)responseJson.get("token_type");
                this.expiresIn = (Integer)responseJson.get("expires_in");
                this.refreshExpiresIn = (Integer)responseJson.get("refresh_expires_in");
                if (responseJson.containsKey("refresh_token")) {
                    this.refreshToken = (String)responseJson.get("refresh_token");
                }
            } else {
                this.error = (String)responseJson.get("error");
                this.errorDescription = responseJson.containsKey("error_description") ? (String)responseJson.get("error_description") : null;
            }
        }

        public String getIdToken() {
            return this.idToken;
        }

        public String getAccessToken() {
            return this.accessToken;
        }

        public String getError() {
            return this.error;
        }

        public String getErrorDescription() {
            return this.errorDescription;
        }

        public int getExpiresIn() {
            return this.expiresIn;
        }

        public int getRefreshExpiresIn() {
            return this.refreshExpiresIn;
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public String getRefreshToken() {
            return this.refreshToken;
        }

        public String getTokenType() {
            return this.tokenType;
        }
    }

    public static class AuthorizationEndpointResponse {
        private boolean isRedirected;
        private String code;
        private String state;
        private String error;
        private String errorDescription;
        private String accessToken;
        private String idToken;

        public AuthorizationEndpointResponse(OAuthClient client) {
            boolean fragment;
            try {
                fragment = client.responseType != null && OIDCResponseType.parse((String)client.responseType).isImplicitOrHybridFlow();
            }
            catch (IllegalArgumentException iae) {
                fragment = false;
            }
            this.init(client, fragment);
        }

        public AuthorizationEndpointResponse(OAuthClient client, boolean fragment) {
            this.init(client, fragment);
        }

        private void init(OAuthClient client, boolean fragment) {
            this.isRedirected = client.getCurrentRequest().equals(client.getRedirectUri());
            Map<String, String> params = fragment ? client.getCurrentFragment() : client.getCurrentQuery();
            this.code = params.get("code");
            this.state = params.get("state");
            this.error = params.get("error");
            this.errorDescription = params.get("error_description");
            this.accessToken = params.get("access_token");
            this.idToken = params.get("id_token");
        }

        public boolean isRedirected() {
            return this.isRedirected;
        }

        public String getCode() {
            return this.code;
        }

        public String getState() {
            return this.state;
        }

        public String getError() {
            return this.error;
        }

        public String getErrorDescription() {
            return this.errorDescription;
        }

        public String getAccessToken() {
            return this.accessToken;
        }

        public String getIdToken() {
            return this.idToken;
        }
    }
}

