/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util;

import com.icegreen.greenmail.util.GreenMail;
import com.icegreen.greenmail.util.ServerSetup;
import java.net.SocketException;
import java.util.HashMap;
import javax.mail.internet.MimeMessage;
import org.junit.rules.ExternalResource;
import org.keycloak.models.RealmModel;

public class GreenMailRule
extends ExternalResource {
    private GreenMail greenMail;

    protected void before() throws Throwable {
        ServerSetup setup = new ServerSetup(3025, "localhost", "smtp");
        this.greenMail = new GreenMail(setup);
        this.greenMail.start();
    }

    protected void after() {
        if (this.greenMail != null) {
            Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread t, Throwable e) {
                    if (!(e.getCause() instanceof SocketException) || !t.getClass().getName().equals("com.icegreen.greenmail.smtp.SmtpHandler")) {
                        System.err.print("Exception in thread \"" + t.getName() + "\" ");
                        e.printStackTrace(System.err);
                    }
                }
            });
            this.greenMail.stop();
        }
    }

    public void configureRealm(RealmModel realm) {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("from", "auto@keycloak.org");
        config.put("host", "localhost");
        config.put("port", "3025");
        realm.setSmtpConfig(config);
    }

    public MimeMessage[] getReceivedMessages() {
        return this.greenMail.getReceivedMessages();
    }
}

