/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.page;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.UriBuilder;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.logging.Logger;
import org.keycloak.testsuite.util.URLUtils;
import org.openqa.selenium.WebDriver;

public abstract class AbstractPage {
    protected final Logger log = Logger.getLogger(this.getClass());
    private final Map<String, Object> uriParameters = new HashMap<String, Object>();
    @Drone
    protected WebDriver driver;
    private UriBuilder builder;

    public WebDriver getDriver() {
        return this.driver;
    }

    public abstract UriBuilder createUriBuilder();

    public String getUriFragment() {
        return "";
    }

    public UriBuilder getUriBuilder() {
        if (this.builder == null) {
            this.builder = this.createUriBuilder();
            String fragment = this.getUriFragment();
            if (fragment != null && !fragment.isEmpty()) {
                this.builder.fragment(fragment);
            }
        }
        return this.builder;
    }

    public AbstractPage setUriParameter(String name, Object value) {
        this.uriParameters.put(name, value);
        return this;
    }

    public AbstractPage removeUriParameter(String name) {
        this.uriParameters.remove(name);
        return this;
    }

    public Object getUriParameter(String name) {
        return this.uriParameters.get(name);
    }

    public URI buildUri() {
        return this.getUriBuilder().buildFromMap(this.uriParameters);
    }

    public String toString() {
        return this.buildUri().toASCIIString();
    }

    public void navigateTo() {
        this.navigateTo(true);
    }

    public void navigateTo(boolean waitForMatch) {
        URLUtils.navigateToUri(this.driver, this.buildUri().toASCIIString(), waitForMatch);
    }

    public boolean isCurrent() {
        return URLUtils.currentUrlEqual(this.driver, this.toString());
    }
}

