/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.console.page.events;

import org.keycloak.testsuite.console.page.events.Events;
import org.keycloak.testsuite.console.page.fragment.OnOffSwitch;
import org.keycloak.testsuite.page.Form;
import org.keycloak.testsuite.util.WaitUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.openqa.selenium.support.ui.Select;

public class Config
extends Events {
    @FindBy(xpath="//form")
    private ConfigForm form;

    @Override
    public String getUriFragment() {
        return super.getUriFragment() + "/events-settings";
    }

    public ConfigForm form() {
        return this.form;
    }

    public class ConfigForm
    extends Form {
        @FindBy(id="s2id_autogen1")
        private WebElement eventListenersInput;
        @FindBy(xpath="//div[@id='s2id_autogen1']/..//select")
        private Select eventListenersSelect;
        @FindBy(xpath=".//div[@class='onoffswitch' and ./input[@id='enabled']]")
        private OnOffSwitch SaveEvents;
        @FindBy(xpath="//div[@id='s2id_enabledEventTypes']//input")
        private WebElement savedTypesInput;
        @FindBy(xpath="//div[@id='select2-drop']/ul")
        private WebElement savedTypesOptions;
        @FindBy(id="expiration")
        private WebElement expirationInput;
        @FindBy(name="expirationUnit")
        private Select expirationUnitSelect;
        @FindBy(xpath=".//div[@class='onoffswitch' and ./input[@id='adminEventsEnabled']]")
        private OnOffSwitch saveAdminEvents;
        @FindBy(xpath=".//div[@class='onoffswitch' and ./input[@id='adminEventsDetailsEnabled']]")
        private OnOffSwitch includeRepresentation;
        @FindBy(xpath="//button[@data-ng-click='clearEvents()']")
        private WebElement clearLoginEventsButton;
        @FindBy(xpath="//button[@data-ng-click='clearAdminEvents()']")
        private WebElement clearAdminEventsButton;

        public void addEventListener(String listener) {
            this.eventListenersInput.click();
            this.eventListenersSelect.selectByVisibleText(listener);
        }

        public void removeEventListener(String listener) {
            this.eventListenersInput.findElement(By.xpath((String)("//div[text()='" + listener + "']/../a"))).click();
        }

        public void setSaveEvents(boolean value) {
            this.SaveEvents.setOn(value);
        }

        public void addSaveType(String type) {
            this.savedTypesInput.click();
            this.savedTypesOptions.findElement(By.xpath((String)("//div[text()='" + type + "']"))).click();
        }

        public void removeSaveType(String type) {
            this.savedTypesInput.findElement(By.xpath((String)("//div[text()='" + type + "']/../a"))).click();
        }

        public void clearLoginEvents() {
            this.clearLoginEventsButton.click();
        }

        public void setExpiration(String value, String unit) {
            this.expirationUnitSelect.selectByVisibleText(unit);
            Form.setInputValue(this.expirationInput, value);
        }

        public void setSaveAdminEvents(boolean value) {
            this.saveAdminEvents.setOn(value);
        }

        public void setIncludeRepresentation(boolean value) {
            this.includeRepresentation.setOn(value);
        }

        public void clearAdminEvents() {
            this.clearAdminEventsButton.click();
        }

        public void waitForClearEventsButtonPresent() {
            WaitUtils.waitUntilElement(this.clearLoginEventsButton).is().present();
        }
    }
}

