/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.console.page;

import java.util.List;
import javax.ws.rs.core.UriBuilder;
import org.keycloak.testsuite.console.page.AdminConsole;
import org.keycloak.testsuite.console.page.fragment.RealmSelector;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class AdminConsoleRealmsRoot
extends AdminConsole {
    @FindBy(xpath="//tr[@data-ng-repeat='r in realms']//a[contains(@class,'ng-binding')]")
    private List<WebElement> realmLinks;
    @FindBy(css="realm-selector")
    protected RealmSelector realmSelector;

    @Override
    public UriBuilder createUriBuilder() {
        return super.createUriBuilder().path("/");
    }

    @Override
    public String getUriFragment() {
        return "/realms";
    }

    public void clickRealm(String realm) {
        boolean linkFound = false;
        for (WebElement realmLink : this.realmLinks) {
            if (!realmLink.getText().equals(realm)) continue;
            linkFound = true;
            realmLink.click();
        }
        if (!linkFound) {
            throw new IllegalStateException("A link for realm '" + realm + "' not found on the Realms page.");
        }
    }
}

