/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.client.resources;

import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.keycloak.representations.idm.AdminEventRepresentation;
import org.keycloak.representations.idm.AuthenticationFlowRepresentation;
import org.keycloak.representations.idm.EventRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.rest.representation.AuthenticatorState;

@Path(value="/realms/master/testing")
@Consumes(value={"application/json"})
public interface TestingResource {
    @GET
    @Path(value="/time-offset")
    @Produces(value={"application/json"})
    public Map<String, String> getTimeOffset();

    @PUT
    @Path(value="/time-offset")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Map<String, String> setTimeOffset(Map<String, String> var1);

    @POST
    @Path(value="/poll-event-queue")
    @Produces(value={"application/json"})
    public EventRepresentation pollEvent();

    @POST
    @Path(value="/poll-admin-event-queue")
    @Produces(value={"application/json"})
    public AdminEventRepresentation pollAdminEvent();

    @POST
    @Path(value="/clear-event-queue")
    @Produces(value={"application/json"})
    public Response clearEventQueue();

    @POST
    @Path(value="/clear-admin-event-queue")
    @Produces(value={"application/json"})
    public Response clearAdminEventQueue();

    @GET
    @Path(value="/clear-event-store")
    @Produces(value={"application/json"})
    public Response clearEventStore();

    @GET
    @Path(value="/clear-event-store-for-realm")
    @Produces(value={"application/json"})
    public Response clearEventStore(@QueryParam(value="realmId") String var1);

    @GET
    @Path(value="/clear-event-store-older-than")
    @Produces(value={"application/json"})
    public Response clearEventStore(@QueryParam(value="realmId") String var1, @QueryParam(value="olderThan") long var2);

    @Path(value="query-events")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public List<EventRepresentation> queryEvents(@QueryParam(value="realmId") String var1, @QueryParam(value="type") List<String> var2, @QueryParam(value="client") String var3, @QueryParam(value="user") String var4, @QueryParam(value="dateFrom") String var5, @QueryParam(value="dateTo") String var6, @QueryParam(value="ipAddress") String var7, @QueryParam(value="first") Integer var8, @QueryParam(value="max") Integer var9);

    @PUT
    @Path(value="/on-event")
    @Consumes(value={"application/json"})
    public void onEvent(EventRepresentation var1);

    @GET
    @Path(value="/clear-admin-event-store")
    @Produces(value={"application/json"})
    public Response clearAdminEventStore();

    @GET
    @Path(value="/clear-admin-event-store-for-realm")
    @Produces(value={"application/json"})
    public Response clearAdminEventStore(@QueryParam(value="realmId") String var1);

    @GET
    @Path(value="/clear-admin-event-store-older-than")
    @Produces(value={"application/json"})
    public Response clearAdminEventStore(@QueryParam(value="realmId") String var1, @QueryParam(value="olderThan") long var2);

    @Path(value="query-admin-events")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public List<AdminEventRepresentation> getAdminEvents(@QueryParam(value="realmId") String var1, @QueryParam(value="operationTypes") List<String> var2, @QueryParam(value="authRealm") String var3, @QueryParam(value="authClient") String var4, @QueryParam(value="authUser") String var5, @QueryParam(value="authIpAddress") String var6, @QueryParam(value="resourcePath") String var7, @QueryParam(value="dateFrom") String var8, @QueryParam(value="dateTo") String var9, @QueryParam(value="first") Integer var10, @QueryParam(value="max") Integer var11);

    @POST
    @Path(value="/on-admin-event")
    @Consumes(value={"application/json"})
    public void onAdminEvent(AdminEventRepresentation var1, @QueryParam(value="includeRepresentation") boolean var2);

    @POST
    @Path(value="/remove-user-session")
    @Produces(value={"application/json"})
    public Response removeUserSession(@QueryParam(value="realm") String var1, @QueryParam(value="session") String var2);

    @POST
    @Path(value="/remove-user-sessions")
    @Produces(value={"application/json"})
    public Response removeUserSessions(@QueryParam(value="realm") String var1);

    @GET
    @Path(value="/get-user-session")
    @Produces(value={"application/json"})
    public Integer getLastSessionRefresh(@QueryParam(value="realm") String var1, @QueryParam(value="session") String var2);

    @POST
    @Path(value="/remove-expired")
    @Produces(value={"application/json"})
    public Response removeExpired(@QueryParam(value="realm") String var1);

    @GET
    @Path(value="/cache/{cache}/{id}")
    @Produces(value={"application/json"})
    public boolean isCached(@PathParam(value="cache") String var1, @PathParam(value="id") String var2);

    @GET
    @Path(value="/verify-code")
    @Produces(value={"application/json"})
    public String verifyCode(@QueryParam(value="realm") String var1, @QueryParam(value="code") String var2);

    @POST
    @Path(value="/update-pass-through-auth-state")
    @Produces(value={"application/json"})
    public AuthenticatorState updateAuthenticator(AuthenticatorState var1);

    @GET
    @Path(value="/run-import")
    @Produces(value={"application/json"})
    public Response runImport();

    @GET
    @Path(value="/run-export")
    @Produces(value={"application/json"})
    public Response runExport();

    @GET
    @Path(value="/valid-credentials")
    @Produces(value={"application/json"})
    public boolean validCredentials(@QueryParam(value="realmName") String var1, @QueryParam(value="userName") String var2, @QueryParam(value="password") String var3);

    @GET
    @Path(value="/user-by-federated-identity")
    @Produces(value={"application/json"})
    public UserRepresentation getUserByFederatedIdentity(@QueryParam(value="realmName") String var1, @QueryParam(value="identityProvider") String var2, @QueryParam(value="userId") String var3, @QueryParam(value="userName") String var4);

    @GET
    @Path(value="/user-by-username-from-fed-factory")
    @Produces(value={"application/json"})
    public UserRepresentation getUserByUsernameFromFedProviderFactory(@QueryParam(value="realmName") String var1, @QueryParam(value="userName") String var2);

    @GET
    @Path(value="/get-client-auth-flow")
    @Produces(value={"application/json"})
    public AuthenticationFlowRepresentation getClientAuthFlow(@QueryParam(value="realmName") String var1);

    @GET
    @Path(value="/get-reset-cred-flow")
    @Produces(value={"application/json"})
    public AuthenticationFlowRepresentation getResetCredFlow(@QueryParam(value="realmName") String var1);

    @GET
    @Path(value="/get-user-by-service-account-client")
    @Produces(value={"application/json"})
    public UserRepresentation getUserByServiceAccountClient(@QueryParam(value="realmName") String var1, @QueryParam(value="clientId") String var2);
}

