/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.auth.page.login;

import javax.ws.rs.core.UriBuilder;
import org.jboss.arquillian.graphene.page.Page;
import org.keycloak.testsuite.auth.page.account.AccountFields;
import org.keycloak.testsuite.auth.page.account.PasswordFields;
import org.keycloak.testsuite.auth.page.login.LoginActions;
import org.keycloak.testsuite.util.WaitUtils;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class ResetCredentials
extends LoginActions {
    @Page
    private AccountFields accountFields;
    @Page
    private PasswordFields passwordFields;
    @FindBy(id="kc-info")
    private WebElement info;

    @Override
    public UriBuilder createUriBuilder() {
        return super.createUriBuilder().path("reset-credentials");
    }

    public void resetCredentials(String value) {
        this.accountFields.setUsername(value);
        this.submit();
    }

    public void updatePassword(String password) {
        this.passwordFields.setNewPassword(password);
        this.passwordFields.setConfirmPassword(password);
        this.submit();
    }

    public String getInfoMessage() {
        WaitUtils.waitUntilElement(this.info, "Info message should be visible").is().present();
        return this.info.getText();
    }
}

