/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.auth.page.login;

import javax.ws.rs.core.UriBuilder;
import org.jboss.arquillian.graphene.page.Page;
import org.jboss.arquillian.graphene.wait.IsElementBuilder;
import org.keycloak.testsuite.auth.page.AuthRealm;
import org.keycloak.testsuite.auth.page.login.LoginForm;
import org.keycloak.testsuite.util.WaitUtils;
import org.openqa.selenium.By;

public abstract class Login
extends AuthRealm {
    public static final String PROTOCOL = "protocol";
    public static final String OIDC = "openid-connect";
    public static final String SAML = "saml";
    public static final String LOGIN_ACTION = "login-action";
    private String keycloakThemeCssName;
    @Page
    private LoginForm form;

    @Override
    public UriBuilder createUriBuilder() {
        return super.createUriBuilder().path((this.getProtocol().equals(OIDC) || this.getProtocol().equals(SAML) ? "protocol/" : "") + "{" + PROTOCOL + "}" + (this.getProtocol().equals(OIDC) ? "/auth" : ""));
    }

    public void setProtocol(String protocol) {
        this.setUriParameter(PROTOCOL, protocol);
    }

    public String getProtocol() {
        return this.getUriParameter(PROTOCOL).toString();
    }

    public LoginForm form() {
        return this.form;
    }

    public void setKeycloakThemeCssName(String name) {
        this.keycloakThemeCssName = name;
    }

    protected By getKeycloakThemeLocator() {
        if (this.keycloakThemeCssName == null) {
            throw new IllegalStateException("keycloakThemeCssName property must be set");
        }
        return By.cssSelector((String)("link[href*='login/" + this.keycloakThemeCssName + "/css/login.css']"));
    }

    public void waitForKeycloakThemeNotPresent() {
        ((IsElementBuilder)WaitUtils.waitUntilElement(this.getKeycloakThemeLocator()).is().not()).present();
    }

    public void waitForKeycloakThemePresent() {
        WaitUtils.waitUntilElement(this.getKeycloakThemeLocator()).is().present();
    }
}

