/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.auth.page.account;

import javax.ws.rs.core.UriBuilder;
import org.jboss.arquillian.graphene.findby.FindByJQuery;
import org.keycloak.testsuite.auth.page.AuthRealm;
import org.keycloak.testsuite.page.PageWithLogOutAction;
import org.keycloak.testsuite.util.WaitUtils;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class AccountManagement
extends AuthRealm
implements PageWithLogOutAction {
    @FindBy(xpath="//a[@id='referer']")
    private WebElement backToRefererLink;
    @FindBy(linkText="Sign Out")
    private WebElement signOutLink;
    @FindBy(linkText="Account")
    private WebElement accountLink;
    @FindBy(linkText="Password")
    private WebElement passwordLink;
    @FindBy(linkText="Authenticator")
    private WebElement authenticatorLink;
    @FindBy(linkText="Sessions")
    private WebElement sessionsLink;
    @FindBy(linkText="Applications")
    private WebElement applicationsLink;
    @FindByJQuery(value="button[value='Save']")
    private WebElement save;
    @FindBy(xpath="//div[@id='kc-error-message']/p")
    private WebElement error;

    @Override
    public UriBuilder createUriBuilder() {
        return super.createUriBuilder().path("account");
    }

    public String getErrorMessage() {
        WaitUtils.waitUntilElement(this.error, "Error message should be present").is().present();
        return this.error.getText();
    }

    public void backToReferer() {
        this.backToRefererLink.click();
    }

    public void signOut() {
        this.signOutLink.click();
    }

    @Override
    public void logOut() {
        this.signOut();
    }

    public void account() {
        this.accountLink.click();
    }

    public void password() {
        this.passwordLink.click();
    }

    public void authenticator() {
        this.authenticatorLink.click();
    }

    public void sessions() {
        this.sessionsLink.click();
    }

    public void applications() {
        this.applicationsLink.click();
    }

    public void save() {
        this.save.click();
    }

    public void waitForAccountLinkPresent() {
        WaitUtils.waitUntilElement(this.accountLink, "account link should be present").is().present();
    }
}

