/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.arquillian.containers;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;
import org.jboss.arquillian.config.descriptor.api.ContainerDef;
import org.jboss.arquillian.config.descriptor.api.GroupDef;
import org.jboss.arquillian.container.spi.ContainerRegistry;
import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.core.api.Injector;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.ApplicationScoped;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.core.spi.ServiceLoader;
import org.jboss.arquillian.core.spi.Validate;
import org.jboss.logging.Logger;
import org.keycloak.testsuite.arquillian.containers.Registry;
import org.keycloak.testsuite.arquillian.containers.SecurityActions;

public class RegistryCreator {
    protected final Logger log = Logger.getLogger(this.getClass());
    @Inject
    @ApplicationScoped
    private InstanceProducer<ContainerRegistry> registry;
    @Inject
    private Instance<Injector> injector;
    @Inject
    private Instance<ServiceLoader> loader;
    private static final String ENABLED = "enabled";
    public static final String ADAPTER_IMPL_CONFIG_STRING = "adapterImplClass";

    public void createRegistry(@Observes ArquillianDescriptor event) {
        Registry reg = new Registry((Injector)this.injector.get());
        ServiceLoader serviceLoader = (ServiceLoader)this.loader.get();
        this.log.info((Object)("arquillian.xml: " + System.getProperty("arquillian.xml")));
        Collection containers = serviceLoader.all(DeployableContainer.class);
        if (containers.isEmpty()) {
            throw new IllegalStateException("There are not any container adapters on the classpath");
        }
        this.createRegistry(event.getContainers(), containers, reg, serviceLoader);
        for (GroupDef group : event.getGroups()) {
            this.createRegistry(group.getGroupContainers(), containers, reg, serviceLoader);
        }
        this.registry.set((Object)reg);
    }

    private void createRegistry(List<ContainerDef> containerDefs, Collection<DeployableContainer> containers, ContainerRegistry reg, ServiceLoader serviceLoader) {
        for (ContainerDef container : containerDefs) {
            if (!this.isCreatingContainer(container, containers)) continue;
            if (this.isEnabled(container)) {
                this.log.info((Object)("Registering container: " + container.getContainerName()));
                reg.create(container, serviceLoader);
                continue;
            }
            this.log.info((Object)("Container is disabled: " + container.getContainerName()));
        }
    }

    private boolean isEnabled(ContainerDef containerDef) {
        Map props = containerDef.getContainerProperties();
        return !props.containsKey(ENABLED) || props.containsKey(ENABLED) && ((String)props.get(ENABLED)).equals("true");
    }

    private boolean isCreatingContainer(ContainerDef containerDef, Collection<DeployableContainer> containers) {
        if (RegistryCreator.hasAdapterImplClassProperty(containerDef) && SecurityActions.isClassPresent(RegistryCreator.getAdapterImplClassValue(containerDef))) {
            return DeployableContainer.class.isAssignableFrom(SecurityActions.loadClass(RegistryCreator.getAdapterImplClassValue(containerDef)));
        }
        return false;
    }

    public static boolean hasAdapterImplClassProperty(ContainerDef containerDef) {
        for (Map.Entry entry : containerDef.getContainerProperties().entrySet()) {
            if (!((String)entry.getKey()).equals(ADAPTER_IMPL_CONFIG_STRING)) continue;
            return true;
        }
        return false;
    }

    public static String getAdapterImplClassValue(ContainerDef containerDef) {
        return ((String)containerDef.getContainerProperties().get(ADAPTER_IMPL_CONFIG_STRING)).trim();
    }

    public static DeployableContainer<?> getContainerAdapter(String adapterImplClass, Collection<DeployableContainer> containers) {
        Validate.notNullOrEmpty((String)adapterImplClass, (String)"The value of adapterImplClass can not be a null object nor an empty string!");
        if (!SecurityActions.isClassPresent(adapterImplClass)) {
            return null;
        }
        Class<?> foundAdapter = SecurityActions.loadClass(adapterImplClass);
        for (DeployableContainer container : containers) {
            if (!foundAdapter.isInstance(container)) continue;
            return container;
        }
        return null;
    }
}

