/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.arquillian.undertow;

import io.undertow.Undertow;
import io.undertow.servlet.Servlets;
import io.undertow.servlet.api.DefaultServletConfig;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.FilterInfo;
import io.undertow.servlet.api.ServletInfo;
import java.util.Collection;
import java.util.Map;
import javax.servlet.DispatcherType;
import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.arquillian.container.spi.client.protocol.ProtocolDescription;
import org.jboss.arquillian.container.spi.client.protocol.metadata.HTTPContext;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.container.spi.client.protocol.metadata.Servlet;
import org.jboss.logging.Logger;
import org.jboss.resteasy.plugins.server.undertow.UndertowJaxrsServer;
import org.jboss.resteasy.spi.ResteasyDeployment;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;
import org.jboss.shrinkwrap.undertow.api.UndertowWebArchive;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.services.filters.KeycloakSessionServletFilter;
import org.keycloak.services.resources.KeycloakApplication;
import org.keycloak.testsuite.arquillian.undertow.KeycloakOnUndertowConfiguration;

public class KeycloakOnUndertow
implements DeployableContainer<KeycloakOnUndertowConfiguration> {
    protected final Logger log = Logger.getLogger(this.getClass());
    private UndertowJaxrsServer undertow;
    private KeycloakOnUndertowConfiguration configuration;
    private KeycloakSessionFactory sessionFactory;

    private DeploymentInfo createAuthServerDeploymentInfo() {
        ResteasyDeployment deployment = new ResteasyDeployment();
        deployment.setApplicationClass(KeycloakApplication.class.getName());
        DeploymentInfo di = this.undertow.undertowDeployment(deployment);
        di.setClassLoader(this.getClass().getClassLoader());
        di.setContextPath("/auth");
        di.setDeploymentName("Keycloak");
        di.setDefaultServletConfig(new DefaultServletConfig(true));
        di.addWelcomePage("theme/keycloak/welcome/resources/index.html");
        FilterInfo filter = Servlets.filter((String)"SessionFilter", KeycloakSessionServletFilter.class);
        di.addFilter(filter);
        di.addFilterUrlMapping("SessionFilter", "/*", DispatcherType.REQUEST);
        return di;
    }

    public DeploymentInfo getDeplotymentInfoFromArchive(Archive<?> archive) {
        if (archive instanceof UndertowWebArchive) {
            return ((UndertowWebArchive)archive).getDeploymentInfo();
        }
        throw new IllegalArgumentException("UndertowContainer only supports UndertowWebArchive or WebArchive.");
    }

    private HTTPContext createHttpContextForDeploymentInfo(DeploymentInfo deploymentInfo) {
        HTTPContext httpContext = new HTTPContext(this.configuration.getBindAddress(), this.configuration.getBindHttpPort());
        Map servlets = deploymentInfo.getServlets();
        Collection servletsInfo = servlets.values();
        for (ServletInfo servletInfo : servletsInfo) {
            httpContext.add(new Servlet(servletInfo.getName(), deploymentInfo.getContextPath()));
        }
        return httpContext;
    }

    public ProtocolMetaData deploy(Archive<?> archive) throws DeploymentException {
        DeploymentInfo di = this.getDeplotymentInfoFromArchive(archive);
        this.undertow.deploy(di);
        return new ProtocolMetaData().addContext((Object)this.createHttpContextForDeploymentInfo(di));
    }

    public void deploy(Descriptor descriptor) throws DeploymentException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Class<KeycloakOnUndertowConfiguration> getConfigurationClass() {
        return KeycloakOnUndertowConfiguration.class;
    }

    public ProtocolDescription getDefaultProtocol() {
        return new ProtocolDescription("Servlet 3.1");
    }

    public void setup(KeycloakOnUndertowConfiguration undertowContainerConfiguration) {
        this.configuration = undertowContainerConfiguration;
    }

    public void start() throws LifecycleException {
        this.log.info((Object)"Starting auth server on embedded Undertow.");
        long start = System.currentTimeMillis();
        if (this.undertow == null) {
            this.undertow = new UndertowJaxrsServer();
        }
        this.undertow.start(Undertow.builder().addHttpListener(this.configuration.getBindHttpPort(), this.configuration.getBindAddress()).setWorkerThreads(this.configuration.getWorkerThreads()).setIoThreads(this.configuration.getWorkerThreads() / 8));
        DeploymentInfo di = this.createAuthServerDeploymentInfo();
        this.undertow.deploy(di);
        ResteasyDeployment deployment = (ResteasyDeployment)di.getServletContextAttributes().get(ResteasyDeployment.class.getName());
        this.sessionFactory = ((KeycloakApplication)deployment.getApplication()).getSessionFactory();
        this.log.info((Object)("Auth server started in " + (System.currentTimeMillis() - start) + " ms\n"));
    }

    public void stop() throws LifecycleException {
        this.log.info((Object)"Stopping auth server.");
        this.sessionFactory.close();
        this.undertow.stop();
    }

    public void undeploy(Archive<?> archive) throws DeploymentException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void undeploy(Descriptor descriptor) throws DeploymentException {
        throw new UnsupportedOperationException("Not implemented");
    }
}

