/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.utils.runonserver;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.keycloak.component.ComponentModel;
import org.keycloak.credential.CredentialModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.representations.idm.ComponentRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testframework.remote.providers.runonserver.FetchOnServer;
import org.keycloak.testframework.remote.providers.runonserver.FetchOnServerWrapper;

public class RunHelpers {
    public static FetchOnServerWrapper<RealmRepresentation> internalRealm() {
        return new FetchOnServerWrapper(){

            public FetchOnServer getRunOnServer() {
                return (FetchOnServer & Serializable)session -> ModelToRepresentation.toRepresentation((KeycloakSession)session, (RealmModel)session.getContext().getRealm(), (boolean)true);
            }

            public Class<RealmRepresentation> getResultClass() {
                return RealmRepresentation.class;
            }
        };
    }

    public static FetchOnServerWrapper<ComponentRepresentation> internalComponent(final String componentId) {
        return new FetchOnServerWrapper(){

            public FetchOnServer getRunOnServer() {
                return (FetchOnServer & Serializable)session -> ModelToRepresentation.toRepresentation((KeycloakSession)session, (ComponentModel)session.getContext().getRealm().getComponent(componentId), (boolean)true);
            }

            public Class<ComponentRepresentation> getResultClass() {
                return ComponentRepresentation.class;
            }
        };
    }

    public static FetchOnServerWrapper<CredentialModel> fetchCredentials(final String username) {
        return new FetchOnServerWrapper(){

            public FetchOnServer getRunOnServer() {
                return (FetchOnServer & Serializable)session -> {
                    RealmModel realm = session.getContext().getRealm();
                    UserModel user = session.users().getUserByUsername(realm, username);
                    List storedCredentialsByType = user.credentialManager().getStoredCredentialsByTypeStream("password").collect(Collectors.toList());
                    return storedCredentialsByType.get(0);
                };
            }

            public Class getResultClass() {
                return CredentialModel.class;
            }
        };
    }
}

