/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.utils.matchers;

import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;

public class HttpResponseBodyMatcher
extends BaseMatcher<HttpResponse> {
    private final Matcher<String> matcher;
    private ThreadLocal<String> lastEntity = new ThreadLocal();

    public HttpResponseBodyMatcher(Matcher<String> matcher) {
        this.matcher = matcher;
    }

    public boolean matches(Object item) {
        this.lastEntity.remove();
        try {
            this.lastEntity.set(EntityUtils.toString((HttpEntity)((HttpResponse)item).getEntity()));
            return item instanceof HttpResponse && this.matcher.matches((Object)this.lastEntity.get());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void describeMismatch(Object item, Description description) {
        Description d = description.appendText("was ").appendValue(item);
        if (this.lastEntity.get() != null) {
            d.appendText(" with entity ").appendText(this.lastEntity.get());
        }
    }

    public void describeTo(Description description) {
        description.appendText("response body matches ").appendDescriptionOf(this.matcher);
    }
}

