/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.utils.admin;

import jakarta.ws.rs.core.UriBuilder;
import java.net.URI;
import org.keycloak.admin.client.resource.AttackDetectionResource;
import org.keycloak.admin.client.resource.AuthenticationManagementResource;
import org.keycloak.admin.client.resource.ClientAttributeCertificateResource;
import org.keycloak.admin.client.resource.ClientInitialAccessResource;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.ClientScopeResource;
import org.keycloak.admin.client.resource.ClientScopesResource;
import org.keycloak.admin.client.resource.ClientsResource;
import org.keycloak.admin.client.resource.ComponentsResource;
import org.keycloak.admin.client.resource.GroupResource;
import org.keycloak.admin.client.resource.GroupsResource;
import org.keycloak.admin.client.resource.IdentityProviderResource;
import org.keycloak.admin.client.resource.IdentityProvidersResource;
import org.keycloak.admin.client.resource.ProtocolMappersResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.RoleByIdResource;
import org.keycloak.admin.client.resource.RoleMappingResource;
import org.keycloak.admin.client.resource.RoleResource;
import org.keycloak.admin.client.resource.RolesResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.admin.client.resource.UsersResource;

public class AdminEventPaths {
    public static String deleteSessionPath(String userSessionId) {
        URI uri = UriBuilder.fromUri((String)"").path(RealmResource.class, "deleteSession").build(new Object[]{userSessionId});
        return uri.toString();
    }

    public static String defaultGroupPath(String groupId) {
        URI uri = UriBuilder.fromUri((String)"").path(RealmResource.class, "addDefaultGroup").build(new Object[]{groupId});
        return uri.toString();
    }

    public static String defaultDefaultClientScopePath(String clientScopeId) {
        URI uri = UriBuilder.fromUri((String)"").path(RealmResource.class, "addDefaultDefaultClientScope").build(new Object[]{clientScopeId});
        return uri.toString();
    }

    public static String defaultOptionalClientScopePath(String clientScopeId) {
        URI uri = UriBuilder.fromUri((String)"").path(RealmResource.class, "addDefaultOptionalClientScope").build(new Object[]{clientScopeId});
        return uri.toString();
    }

    public static String userProfilePath() {
        URI uri = UriBuilder.fromUri((String)"").path(RealmResource.class, "users").path(UsersResource.class, "userProfile").build(new Object[0]);
        return uri.toString();
    }

    public static String clientResourcePath(String clientDbId) {
        URI uri = UriBuilder.fromUri((String)"").path(RealmResource.class, "clients").path(ClientsResource.class, "get").build(new Object[]{clientDbId});
        return uri.toString();
    }

    public static String clientRolesResourcePath(String clientDbId) {
        URI uri = UriBuilder.fromUri((String)AdminEventPaths.clientResourcePath(clientDbId)).path(ClientResource.class, "roles").build(new Object[0]);
        return uri.toString();
    }

    public static String clientRoleResourcePath(String clientDbId, String roleName) {
        URI uri = UriBuilder.fromUri((String)AdminEventPaths.clientRolesResourcePath(clientDbId)).path(RolesResource.class, "get").build(new Object[]{roleName});
        return uri.toString();
    }

    public static String clientRoleResourceCompositesPath(String clientDbId, String roleName) {
        URI uri = UriBuilder.fromUri((String)AdminEventPaths.clientRoleResourcePath(clientDbId, roleName)).path(RoleResource.class, "getRoleComposites").build(new Object[0]);
        return uri.toString();
    }

    public static String clientProtocolMappersPath(String clientDbId) {
        URI uri = UriBuilder.fromUri((String)AdminEventPaths.clientResourcePath(clientDbId)).path(ClientResource.class, "getProtocolMappers").build(new Object[0]);
        return uri.toString();
    }

    public static String clientProtocolMapperPath(String clientDbId, String protocolMapperId) {
        URI uri = UriBuilder.fromUri((String)AdminEventPaths.clientProtocolMappersPath(clientDbId)).path(ProtocolMappersResource.class, "getMapperById").build(new Object[]{protocolMapperId});
        return uri.toString();
    }

    public static String clientPushRevocationPath(String clientDbId) {
        URI uri = UriBuilder.fromUri((String)AdminEventPaths.clientResourcePath(clientDbId)).path(ClientResource.class, "pushRevocation").build(new Object[0]);
        return uri.toString();
    }

    public static String clientNodesPath(String clientDbId) {
        URI uri = UriBuilder.fromUri((String)AdminEventPaths.clientResourcePath(clientDbId)).path(ClientResource.class, "registerNode").build(new Object[0]);
        return uri.toString();
    }

    public static String clientNodePath(String clientDbId, String node) {
        URI uri = UriBuilder.fromUri((String)AdminEventPaths.clientResourcePath(clientDbId)).path(ClientResource.class, "unregisterNode").build(new Object[]{node});
        return uri.toString();
    }

    public static String clientTestNodesAvailablePath(String clientDbId) {
        URI uri = UriBuilder.fromUri((String)AdminEventPaths.clientResourcePath(clientDbId)).path(ClientResource.class, "testNodesAvailable").build(new Object[0]);
        return uri.toString();
    }

    public static String clientGenerateSecretPath(String clientDbId) {
        URI uri = UriBuilder.fromUri((String)AdminEventPaths.clientResourcePath(clientDbId)).path(ClientResource.class, "generateNewSecret").build(new Object[0]);
        return uri.toString();
    }

    public static String clientRegenerateRegistrationAccessTokenPath(String clientDbId) {
        URI uri = UriBuilder.fromUri((String)AdminEventPaths.clientResourcePath(clientDbId)).path(ClientResource.class, "regenerateRegistrationAccessToken").build(new Object[0]);
        return uri.toString();
    }

    public static String clientCertificateGenerateSecretPath(String clientDbId, String certificateAttribute) {
        URI uri = UriBuilder.fromUri((String)AdminEventPaths.clientResourcePath(clientDbId)).path(ClientResource.class, "getCertficateResource").path(ClientAttributeCertificateResource.class, "generate").build(new Object[]{certificateAttribute});
        return uri.toString();
    }

    public static String clientScopeMappingsRealmLevelPath(String clientDbId) {
        URI uri = UriBuilder.fromUri((String)AdminEventPaths.clientResourcePath(clientDbId)).path(ClientResource.class, "getScopeMappings").path(RoleMappingResource.class, "realmLevel").build(new Object[0]);
        return uri.toString();
    }

    public static String clientScopeMappingsClientLevelPath(String clientDbId, String clientOwningRoleId) {
        URI uri = UriBuilder.fromUri((String)AdminEventPaths.clientResourcePath(clientDbId)).path(ClientResource.class, "getScopeMappings").path(RoleMappingResource.class, "clientLevel").build(new Object[]{clientOwningRoleId});
        return uri.toString();
    }

    public static String clientScopeResourcePath(String clientScopeId) {
        URI uri = UriBuilder.fromUri((String)"").path(RealmResource.class, "clientScopes").path(ClientScopesResource.class, "get").build(new Object[]{clientScopeId});
        return uri.toString();
    }

    public static String clientScopeGenerateAudienceClientScopePath() {
        URI uri = UriBuilder.fromUri((String)"").path(RealmResource.class, "clientScopes").path(ClientScopesResource.class, "generateAudienceClientScope").build(new Object[0]);
        return uri.toString();
    }

    public static String clientScopeRoleMappingsRealmLevelPath(String clientScopeDbId) {
        URI uri = UriBuilder.fromUri((String)AdminEventPaths.clientScopeResourcePath(clientScopeDbId)).path(ClientScopeResource.class, "getScopeMappings").path(RoleMappingResource.class, "realmLevel").build(new Object[0]);
        return uri.toString();
    }

    public static String clientScopeRoleMappingsClientLevelPath(String clientScopeDbId, String clientOwningRoleId) {
        URI uri = UriBuilder.fromUri((String)AdminEventPaths.clientScopeResourcePath(clientScopeDbId)).path(ClientScopeResource.class, "getScopeMappings").path(RoleMappingResource.class, "clientLevel").build(new Object[]{clientOwningRoleId});
        return uri.toString();
    }

    public static String clientScopeProtocolMappersPath(String clientScopeDbId) {
        URI uri = UriBuilder.fromUri((String)AdminEventPaths.clientScopeResourcePath(clientScopeDbId)).path(ClientScopeResource.class, "getProtocolMappers").build(new Object[0]);
        return uri.toString();
    }

    public static String clientScopeProtocolMapperPath(String clientScopeDbId, String protocolMapperId) {
        URI uri = UriBuilder.fromUri((String)AdminEventPaths.clientScopeProtocolMappersPath(clientScopeDbId)).path(ProtocolMappersResource.class, "getMapperById").build(new Object[]{protocolMapperId});
        return uri.toString();
    }

    public static String rolesResourcePath() {
        URI uri = UriBuilder.fromUri((String)"").path(RealmResource.class, "roles").build(new Object[0]);
        return uri.toString();
    }

    public static String roleResourcePath(String roleName) {
        URI uri = UriBuilder.fromUri((String)AdminEventPaths.rolesResourcePath()).path(RolesResource.class, "get").build(new Object[]{roleName});
        return uri.toString();
    }

    public static String roleResourceCompositesPath(String roleName) {
        URI uri = UriBuilder.fromUri((String)AdminEventPaths.roleResourcePath(roleName)).path(RoleResource.class, "getRoleComposites").build(new Object[0]);
        return uri.toString();
    }

    public static String rolesByIdResourcePath() {
        URI uri = UriBuilder.fromUri((String)"").path(RealmResource.class, "rolesById").build(new Object[0]);
        return uri.toString();
    }

    public static String roleByIdResourcePath(String roleId) {
        URI uri = UriBuilder.fromUri((String)AdminEventPaths.rolesByIdResourcePath()).path(RoleByIdResource.class, "getRole").build(new Object[]{roleId});
        return uri.toString();
    }

    public static String roleByIdResourceCompositesPath(String roleId) {
        URI uri = UriBuilder.fromUri((String)AdminEventPaths.rolesByIdResourcePath()).path(RoleByIdResource.class, "getRoleComposites").build(new Object[]{roleId});
        return uri.toString();
    }

    public static String userResourcePath(String userId) {
        URI uri = UriBuilder.fromUri((String)"").path(RealmResource.class, "users").path(UsersResource.class, "get").build(new Object[]{userId});
        return uri.toString();
    }

    public static String userResetPasswordPath(String userId) {
        URI uri = UriBuilder.fromUri((String)AdminEventPaths.userResourcePath(userId)).path(UserResource.class, "resetPassword").build(new Object[]{userId});
        return uri.toString();
    }

    public static String userRealmRoleMappingsPath(String userId) {
        URI uri = UriBuilder.fromUri((String)AdminEventPaths.userResourcePath(userId)).path(UserResource.class, "roles").path(RoleMappingResource.class, "realmLevel").build(new Object[0]);
        return uri.toString();
    }

    public static String userClientRoleMappingsPath(String userId, String clientDbId) {
        URI uri = UriBuilder.fromUri((String)AdminEventPaths.userResourcePath(userId)).path(UserResource.class, "roles").path(RoleMappingResource.class, "clientLevel").build(new Object[]{clientDbId});
        return uri.toString();
    }

    public static String userFederatedIdentityLink(String userId, String idpAlias) {
        URI uri = UriBuilder.fromUri((String)AdminEventPaths.userResourcePath(userId)).path(UserResource.class, "addFederatedIdentity").build(new Object[]{idpAlias});
        return uri.toString();
    }

    public static String userGroupPath(String userId, String groupId) {
        URI uri = UriBuilder.fromUri((String)AdminEventPaths.userResourcePath(userId)).path(UserResource.class, "joinGroup").build(new Object[]{groupId});
        return uri.toString();
    }

    public static String identityProvidersPath() {
        URI uri = UriBuilder.fromUri((String)"").path(RealmResource.class, "identityProviders").build(new Object[0]);
        return uri.toString();
    }

    public static String identityProviderCreatePath() {
        URI uri = UriBuilder.fromUri((String)AdminEventPaths.identityProvidersPath()).path(IdentityProvidersResource.class, "create").build(new Object[0]);
        return uri.toString();
    }

    public static String identityProviderPath(String idpAlias) {
        URI uri = UriBuilder.fromUri((String)AdminEventPaths.identityProvidersPath()).path(IdentityProvidersResource.class, "get").build(new Object[]{idpAlias});
        return uri.toString();
    }

    public static String identityProviderMapperPath(String idpAlias, String idpMapperId) {
        URI uri = UriBuilder.fromUri((String)AdminEventPaths.identityProviderPath(idpAlias)).path(IdentityProviderResource.class, "getMapperById").build(new Object[]{idpMapperId});
        return uri.toString();
    }

    public static String componentsPath() {
        URI uri = UriBuilder.fromUri((String)"").path(RealmResource.class, "components").build(new Object[0]);
        return uri.toString();
    }

    public static String componentPath(String componentId) {
        URI uri = UriBuilder.fromUri((String)AdminEventPaths.componentsPath()).path(ComponentsResource.class, "component").build(new Object[]{componentId});
        return uri.toString();
    }

    public static String clientInitialAccessPath(String clientInitialAccessId) {
        URI uri = UriBuilder.fromUri((String)"").path(RealmResource.class, "clientInitialAccess").path(ClientInitialAccessResource.class, "delete").build(new Object[]{clientInitialAccessId});
        return uri.toString();
    }

    public static String groupsPath() {
        URI uri = UriBuilder.fromUri((String)"").path(RealmResource.class, "groups").build(new Object[0]);
        return uri.toString();
    }

    public static String groupPath(String groupId) {
        URI uri = UriBuilder.fromUri((String)AdminEventPaths.groupsPath()).path(GroupsResource.class, "group").build(new Object[]{groupId});
        return uri.toString();
    }

    public static String groupRolesPath(String groupId) {
        URI uri = UriBuilder.fromUri((String)AdminEventPaths.groupPath(groupId)).path(GroupResource.class, "roles").build(new Object[0]);
        return uri.toString();
    }

    public static String groupRolesRealmRolesPath(String groupId) {
        URI uri = UriBuilder.fromUri((String)AdminEventPaths.groupRolesPath(groupId)).path(RoleMappingResource.class, "realmLevel").build(new Object[0]);
        return uri.toString();
    }

    public static String groupRolesClientRolesPath(String groupId, String clientDbId) {
        URI uri = UriBuilder.fromUri((String)AdminEventPaths.groupRolesPath(groupId)).path(RoleMappingResource.class, "clientLevel").build(new Object[]{clientDbId});
        return uri.toString();
    }

    public static String groupSubgroupsPath(String groupId) {
        URI uri = UriBuilder.fromUri((String)AdminEventPaths.groupPath(groupId)).path(GroupResource.class, "subGroup").build(new Object[0]);
        return uri.toString();
    }

    public static String authMgmtBasePath() {
        URI uri = UriBuilder.fromUri((String)"").path(RealmResource.class, "flows").build(new Object[0]);
        return uri.toString();
    }

    public static String authFlowsPath() {
        URI uri = UriBuilder.fromUri((String)AdminEventPaths.authMgmtBasePath()).path(AuthenticationManagementResource.class, "getFlows").build(new Object[0]);
        return uri.toString();
    }

    public static String authFlowPath(String flowId) {
        URI uri = UriBuilder.fromUri((String)AdminEventPaths.authMgmtBasePath()).path(AuthenticationManagementResource.class, "getFlow").build(new Object[]{flowId});
        return uri.toString();
    }

    public static String authCopyFlowPath(String flowAlias) {
        URI uri = UriBuilder.fromUri((String)AdminEventPaths.authMgmtBasePath()).path(AuthenticationManagementResource.class, "copy").build(new Object[]{flowAlias});
        return uri.toString();
    }

    public static String authEditFlowPath(String flowId) {
        URI uri = UriBuilder.fromUri((String)AdminEventPaths.authMgmtBasePath()).path(AuthenticationManagementResource.class, "updateFlow").build(new Object[]{flowId});
        return uri.toString();
    }

    public static String authAddExecutionFlowPath(String flowAlias) {
        URI uri = UriBuilder.fromUri((String)AdminEventPaths.authMgmtBasePath()).path(AuthenticationManagementResource.class, "addExecutionFlow").build(new Object[]{flowAlias});
        return uri.toString();
    }

    public static String authAddExecutionPath(String flowAlias) {
        return AdminEventPaths.authFlowPath(flowAlias) + "/executions/execution";
    }

    public static String authUpdateExecutionPath(String flowAlias) {
        URI uri = UriBuilder.fromUri((String)AdminEventPaths.authMgmtBasePath()).path(AuthenticationManagementResource.class, "updateExecutions").build(new Object[]{flowAlias});
        return uri.toString();
    }

    public static String authExecutionPath(String executionId) {
        URI uri = UriBuilder.fromUri((String)AdminEventPaths.authMgmtBasePath()).path(AuthenticationManagementResource.class, "removeExecution").build(new Object[]{executionId});
        return uri.toString();
    }

    public static String authAddExecutionConfigPath(String executionId) {
        URI uri = UriBuilder.fromUri((String)AdminEventPaths.authMgmtBasePath()).path(AuthenticationManagementResource.class, "newExecutionConfig").build(new Object[]{executionId});
        return uri.toString();
    }

    public static String authExecutionConfigPath(String configId) {
        URI uri = UriBuilder.fromUri((String)AdminEventPaths.authMgmtBasePath()).path(AuthenticationManagementResource.class, "getAuthenticatorConfig").build(new Object[]{configId});
        return uri.toString();
    }

    public static String authRaiseExecutionPath(String executionId) {
        URI uri = UriBuilder.fromUri((String)AdminEventPaths.authMgmtBasePath()).path(AuthenticationManagementResource.class, "raisePriority").build(new Object[]{executionId});
        return uri.toString();
    }

    public static String authLowerExecutionPath(String executionId) {
        URI uri = UriBuilder.fromUri((String)AdminEventPaths.authMgmtBasePath()).path(AuthenticationManagementResource.class, "lowerPriority").build(new Object[]{executionId});
        return uri.toString();
    }

    public static String authRequiredActionPath(String requiredActionAlias) {
        URI uri = UriBuilder.fromUri((String)AdminEventPaths.authMgmtBasePath()).path(AuthenticationManagementResource.class, "getRequiredAction").build(new Object[]{requiredActionAlias});
        return uri.toString();
    }

    public static String authRequiredActionConfigPath(String requiredActionAlias) {
        URI uri = UriBuilder.fromUri((String)AdminEventPaths.authMgmtBasePath()).path(AuthenticationManagementResource.class, "getRequiredActionConfig").build(new Object[]{requiredActionAlias});
        return uri.toString();
    }

    public static String authRaiseRequiredActionPath(String requiredActionAlias) {
        URI uri = UriBuilder.fromUri((String)AdminEventPaths.authMgmtBasePath()).path(AuthenticationManagementResource.class, "raiseRequiredActionPriority").build(new Object[]{requiredActionAlias});
        return uri.toString();
    }

    public static String authLowerRequiredActionPath(String requiredActionAlias) {
        URI uri = UriBuilder.fromUri((String)AdminEventPaths.authMgmtBasePath()).path(AuthenticationManagementResource.class, "lowerRequiredActionPriority").build(new Object[]{requiredActionAlias});
        return uri.toString();
    }

    public static String attackDetectionClearBruteForceForUserPath(String username) {
        URI uri = UriBuilder.fromUri((String)"").path(RealmResource.class, "attackDetection").path(AttackDetectionResource.class, "clearBruteForceForUser").build(new Object[]{username});
        return uri.toString();
    }

    public static String attackDetectionClearAllBruteForcePath() {
        URI uri = UriBuilder.fromUri((String)"").path(RealmResource.class, "attackDetection").path(AttackDetectionResource.class, "clearAllBruteForce").build(new Object[0]);
        return uri.toString();
    }
}

