/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util.oauth;

import java.io.IOException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.keycloak.testsuite.util.oauth.AbstractHttpPostRequest;
import org.keycloak.testsuite.util.oauth.AbstractOAuthClient;
import org.keycloak.testsuite.util.oauth.AccessTokenResponse;

public class ClientCredentialsGrantRequest
extends AbstractHttpPostRequest<ClientCredentialsGrantRequest, AccessTokenResponse> {
    ClientCredentialsGrantRequest(AbstractOAuthClient<?> client) {
        super(client);
    }

    public ClientCredentialsGrantRequest dpopProof(String dpopProof) {
        this.header("DPoP", dpopProof);
        return this;
    }

    @Override
    protected String getEndpoint() {
        return this.client.getEndpoints().getToken();
    }

    @Override
    protected void initRequest() {
        this.parameter("grant_type", "client_credentials");
        this.scope();
    }

    @Override
    protected AccessTokenResponse toResponse(CloseableHttpResponse response) throws IOException {
        return new AccessTokenResponse(response);
    }
}

