/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util.oauth;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.util.EntityUtils;
import org.keycloak.util.JsonSerialization;

public abstract class AbstractHttpResponse {
    private final CloseableHttpResponse response;
    private final int statusCode;
    private final Map<String, String> headers;
    private String error;
    private String errorDescription;

    public AbstractHttpResponse(CloseableHttpResponse response) throws IOException {
        try (CloseableHttpResponse closeableHttpResponse = response;){
            this.response = response;
            this.statusCode = response.getStatusLine().getStatusCode();
            this.headers = new HashMap<String, String>();
            for (Header h : response.getAllHeaders()) {
                this.headers.put(h.getName(), h.getValue());
            }
            if (this.isSuccess()) {
                this.parseContent();
            } else if (this.isJson()) {
                this.parseError();
            }
        }
    }

    protected int getSuccessCode() {
        return 200;
    }

    public boolean isSuccess() {
        return this.statusCode == this.getSuccessCode();
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getHeader(String name) {
        return this.headers.get(name);
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public String getError() {
        return this.error;
    }

    protected void setError(String error) {
        this.error = error;
    }

    public String getErrorDescription() {
        return this.errorDescription;
    }

    protected String getContentType() {
        Header[] contentTypeHeaders = this.response.getHeaders("Content-Type");
        return contentTypeHeaders != null && contentTypeHeaders.length > 0 ? contentTypeHeaders[0].getValue() : null;
    }

    protected ObjectNode asJson() throws IOException {
        return this.asJson(ObjectNode.class);
    }

    protected <S> S asJson(Class<S> clazz) throws IOException {
        this.assertJsonContentType();
        return (S)JsonSerialization.readValue((InputStream)this.response.getEntity().getContent(), clazz);
    }

    protected String asString() throws IOException {
        return EntityUtils.toString((HttpEntity)this.response.getEntity(), (Charset)StandardCharsets.UTF_8);
    }

    protected abstract void parseContent() throws IOException;

    protected void parseError() throws IOException {
        if (this.getStatusCode() == 504) {
            return;
        }
        ObjectNode json = this.asJson(ObjectNode.class);
        this.error = json.has("error") ? json.get("error").asText() : null;
        this.errorDescription = json.has("error_description") ? json.get("error_description").asText() : null;
    }

    protected boolean isJson() {
        return "application/json".equals(this.getContentType());
    }

    protected void assertJsonContentType() throws IOException {
        String contentType = this.getContentType();
        if (contentType == null || !contentType.startsWith("application/json")) {
            throw new IOException("Invalid content type retrieved. Status: " + this.getStatusCode() + ", contentType: " + contentType);
        }
    }
}

